/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.generator.Model;
import ch.ralscha.extdirectspring.generator.ModelBean;
import ch.ralscha.extdirectspring.generator.ModelField;
import ch.ralscha.extdirectspring.generator.ModelFieldBean;
import ch.ralscha.extdirectspring.generator.ModelType;
import ch.ralscha.extdirectspring.generator.OutputFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class ModelGenerator {
    private static final Map<JsCacheKey, SoftReference<String>> jsCache = new ConcurrentHashMap<JsCacheKey, SoftReference<String>>();
    private static final Map<String, SoftReference<ModelBean>> modelCache = new ConcurrentHashMap<String, SoftReference<ModelBean>>();

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, clazz, format, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format, boolean debug) throws IOException {
        ModelBean model = ModelGenerator.createModel(clazz);
        ModelGenerator.writeModel(request, response, model, format, debug);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, model, format, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format, boolean debug) throws IOException {
        RouterController routerController = (RouterController)RequestContextUtils.getWebApplicationContext((ServletRequest)request).getBean(RouterController.class);
        byte[] data = ModelGenerator.generateJavascript(model, format, debug).getBytes(RouterController.UTF8_CHARSET);
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = "\"0" + DigestUtils.md5DigestAsHex((byte[])data) + "\"";
        if (etag.equals(ifNoneMatch)) {
            response.setStatus(304);
            return;
        }
        response.setContentType(routerController.getConfiguration().getJsContentType());
        response.setCharacterEncoding(RouterController.UTF8_CHARSET.name());
        response.setContentLength(data.length);
        response.setHeader("ETag", etag);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }

    public static ModelBean createModel(Class<?> clazz) {
        BeanInfo bi;
        SoftReference<ModelBean> modelReference = modelCache.get(clazz.getName());
        if (modelReference != null && modelReference.get() != null) {
            return modelReference.get();
        }
        Model modelAnnotation = clazz.getAnnotation(Model.class);
        ModelBean model = new ModelBean();
        if (modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value())) {
            model.setName(modelAnnotation.value());
        } else {
            model.setName(clazz.getName());
        }
        if (modelAnnotation != null) {
            model.setIdProperty(modelAnnotation.idProperty());
            model.setPaging(modelAnnotation.paging());
            if (StringUtils.hasText((String)modelAnnotation.createMethod())) {
                model.setCreateMethod(modelAnnotation.createMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.readMethod())) {
                model.setReadMethod(modelAnnotation.readMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.updateMethod())) {
                model.setUpdateMethod(modelAnnotation.updateMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.destroyMethod())) {
                model.setDestroyMethod(modelAnnotation.destroyMethod());
            }
        }
        final HashSet<String> hasReadMethod = new HashSet<String>();
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            if (pd.getReadMethod() == null || pd.getReadMethod().getAnnotation(JsonIgnore.class) != null) continue;
            hasReadMethod.add(pd.getName());
        }
        final ArrayList<ModelFieldBean> modelFields = new ArrayList<ModelFieldBean>();
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){
            private final Set<String> fields = new HashSet<String>();

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if ((Modifier.isPublic(field.getModifiers()) || hasReadMethod.contains(field.getName())) && field.getAnnotation(JsonIgnore.class) == null && !this.fields.contains(field.getName())) {
                    ModelField modelFieldAnnotation;
                    this.fields.add(field.getName());
                    Class<?> javaType = field.getType();
                    ModelType modelType = null;
                    for (ModelType mt : ModelType.values()) {
                        if (!mt.supports(javaType)) continue;
                        modelType = mt;
                        break;
                    }
                    if ((modelFieldAnnotation = field.getAnnotation(ModelField.class)) != null) {
                        String name = StringUtils.hasText((String)modelFieldAnnotation.value()) ? modelFieldAnnotation.value() : field.getName();
                        ModelType type = modelFieldAnnotation.type() != ModelType.AUTO ? modelFieldAnnotation.type() : (modelType != null ? modelType : ModelType.AUTO);
                        ModelFieldBean modelFieldBean = new ModelFieldBean(name, type);
                        if (StringUtils.hasText((String)modelFieldAnnotation.dateFormat()) && type == ModelType.DATE) {
                            modelFieldBean.setDateFormat(modelFieldAnnotation.dateFormat());
                        }
                        if (StringUtils.hasText((String)modelFieldAnnotation.defaultValue())) {
                            if (type == ModelType.BOOLEAN) {
                                modelFieldBean.setDefaultValue(Boolean.parseBoolean(modelFieldAnnotation.defaultValue()));
                            } else if (type == ModelType.INTEGER) {
                                modelFieldBean.setDefaultValue(Long.valueOf(modelFieldAnnotation.defaultValue()));
                            } else if (type == ModelType.FLOAT) {
                                modelFieldBean.setDefaultValue(Double.valueOf(modelFieldAnnotation.defaultValue()));
                            } else {
                                modelFieldBean.setDefaultValue(modelFieldAnnotation.defaultValue());
                            }
                        }
                        if (modelFieldAnnotation.useNull() && (type == ModelType.INTEGER || type == ModelType.FLOAT || type == ModelType.STRING || type == ModelType.BOOLEAN)) {
                            modelFieldBean.setUseNull(true);
                        }
                        modelFields.add(modelFieldBean);
                    } else if (modelType != null) {
                        modelFields.add(new ModelFieldBean(field.getName(), modelType));
                    }
                }
            }
        });
        model.addFields(modelFields);
        modelCache.put(clazz.getName(), new SoftReference<ModelBean>(model));
        return model;
    }

    public static String generateJavascript(Class<?> clazz, OutputFormat format, boolean debug) {
        ModelBean model = ModelGenerator.createModel(clazz);
        return ModelGenerator.generateJavascript(model, format, debug);
    }

    public static String generateJavascript(ModelBean model, OutputFormat format, boolean debug) {
        String configObjectString;
        JsCacheKey key = new JsCacheKey(model, format, debug);
        SoftReference<String> jsReference = jsCache.get(key);
        if (jsReference != null && jsReference.get() != null) {
            return jsReference.get();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        LinkedHashMap<String, Object> modelObject = new LinkedHashMap<String, Object>();
        modelObject.put("extend", "Ext.data.Model");
        LinkedHashMap<String, Object> configObject = new LinkedHashMap<String, Object>();
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            configObject.put("idProperty", model.getIdProperty());
        }
        configObject.put("fields", model.getFields().values());
        LinkedHashMap<String, Object> proxyObject = new LinkedHashMap<String, Object>();
        proxyObject.put("type", "direct");
        LinkedHashMap<String, String> apiObject = new LinkedHashMap<String, String>();
        if (StringUtils.hasText((String)model.getReadMethod()) && !StringUtils.hasText((String)model.getCreateMethod()) && !StringUtils.hasText((String)model.getUpdateMethod()) && !StringUtils.hasText((String)model.getDestroyMethod())) {
            proxyObject.put("directFn", model.getReadMethod());
        } else {
            if (StringUtils.hasText((String)model.getReadMethod())) {
                apiObject.put("read", model.getReadMethod());
            }
            if (StringUtils.hasText((String)model.getCreateMethod())) {
                apiObject.put("create", model.getCreateMethod());
            }
            if (StringUtils.hasText((String)model.getUpdateMethod())) {
                apiObject.put("update", model.getUpdateMethod());
            }
            if (StringUtils.hasText((String)model.getDestroyMethod())) {
                apiObject.put("destroy", model.getDestroyMethod());
            }
            if (!apiObject.isEmpty()) {
                proxyObject.put("api", apiObject);
            }
        }
        if (model.isPaging()) {
            LinkedHashMap<String, String> readerObject = new LinkedHashMap<String, String>();
            readerObject.put("root", "records");
            proxyObject.put("reader", readerObject);
        }
        if (!apiObject.isEmpty() || proxyObject.containsKey("directFn")) {
            configObject.put("proxy", proxyObject);
        }
        if (format == OutputFormat.EXTJS4) {
            modelObject.putAll(configObject);
        } else {
            modelObject.put("config", configObject);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Ext.define('").append(model.getName()).append("',");
        if (debug) {
            sb.append("\n");
        }
        try {
            configObjectString = debug ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(modelObject) : mapper.writeValueAsString(modelObject);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        configObjectString = configObjectString.replace("\"", "'");
        configObjectString = configObjectString.replaceAll("directFn( ?: ?)'([^']+)'", "directFn$1$2");
        configObjectString = configObjectString.replaceAll("read( ?: ?)'([^']+)'", "read$1$2");
        configObjectString = configObjectString.replaceAll("create( ?: ?)'([^']+)'", "create$1$2");
        configObjectString = configObjectString.replaceAll("update( ?: ?)'([^']+)'", "update$1$2");
        configObjectString = configObjectString.replaceAll("destroy( ?: ?)'([^']+)'", "destroy$1$2");
        sb.append(configObjectString);
        sb.append(");");
        String result = sb.toString();
        jsCache.put(key, new SoftReference<String>(result));
        return result;
    }

    private static class JsCacheKey {
        private final ModelBean modelBean;
        private final OutputFormat format;
        private final boolean debug;

        JsCacheKey(ModelBean modelBean, OutputFormat format, boolean debug) {
            this.modelBean = modelBean;
            this.format = format;
            this.debug = debug;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.debug ? 1231 : 1237);
            result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
            result = 31 * result + (this.modelBean == null ? 0 : this.modelBean.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JsCacheKey other = (JsCacheKey)obj;
            if (this.debug != other.debug) {
                return false;
            }
            if (this.format != other.format) {
                return false;
            }
            return !(this.modelBean == null ? other.modelBean != null : !this.modelBean.equals(other.modelBean));
        }
    }
}

