/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.SupportedParameters;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public final class ParameterInfo {
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private String name;
    private final TypeDescriptor typeDescriptor;
    private final boolean supportedParameter;
    private boolean hasRequestParamAnnotation;
    private boolean hasRequestHeaderAnnotation;
    private boolean required;
    private String defaultValue;

    public ParameterInfo(Method method, int paramIndex) {
        Annotation[] paramAnnotations;
        MethodParameter methodParam = new MethodParameter(method, paramIndex);
        methodParam.initParameterNameDiscovery((ParameterNameDiscoverer)discoverer);
        GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, method.getClass());
        this.name = methodParam.getParameterName();
        this.typeDescriptor = new TypeDescriptor(methodParam);
        this.supportedParameter = SupportedParameters.isSupported(this.typeDescriptor.getObjectType());
        for (Annotation paramAnn : paramAnnotations = methodParam.getParameterAnnotations()) {
            if (RequestParam.class.isInstance(paramAnn)) {
                RequestParam requestParam = (RequestParam)paramAnn;
                if (StringUtils.hasText((String)requestParam.value())) {
                    this.name = requestParam.value();
                }
                this.required = requestParam.required();
                this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue()) ? null : requestParam.defaultValue();
                this.hasRequestParamAnnotation = true;
                this.hasRequestHeaderAnnotation = false;
                break;
            }
            if (!RequestHeader.class.isInstance(paramAnn)) continue;
            RequestHeader requestHeader = (RequestHeader)paramAnn;
            if (StringUtils.hasText((String)requestHeader.value())) {
                this.name = requestHeader.value();
            }
            this.required = requestHeader.required();
            this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestHeader.defaultValue()) ? null : requestHeader.defaultValue();
            this.hasRequestParamAnnotation = false;
            this.hasRequestHeaderAnnotation = true;
            break;
        }
    }

    public Class<?> getType() {
        return this.typeDescriptor.getType();
    }

    public Class<?> getCollectionType() {
        if (this.typeDescriptor.isCollection()) {
            return this.typeDescriptor.getElementTypeDescriptor().getType();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHasRequestParamAnnotation() {
        return this.hasRequestParamAnnotation;
    }

    public boolean isHasRequestHeaderAnnotation() {
        return this.hasRequestHeaderAnnotation;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSupportedParameter() {
        return this.supportedParameter;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }
}

