/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.bean.api.RemotingApi;
import ch.ralscha.extdirectspring.bean.api.RemotingApiMixin;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.ApiCache;
import ch.ralscha.extdirectspring.util.ApiCacheKey;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ApiController {
    @Autowired
    private RouterController routerController;

    @RequestMapping(value={"/api.js", "/api-debug.js", "/api-debug-doc.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false, defaultValue="Ext.app") String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false, defaultValue="REMOTING_API") String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false, defaultValue="POLLING_URLS") String pollingUrlsVar, @RequestParam(value="sseVar", required=false, defaultValue="SSE") String sseVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false, defaultValue="false") boolean fullRouterUrl, @RequestParam(value="format", required=false) String format, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (format == null) {
            response.setContentType(this.routerController.getConfiguration().getJsContentType());
            response.setCharacterEncoding(RouterController.UTF8_CHARSET.name());
            String apiString = this.buildAndCacheApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, sseVar, group, fullRouterUrl, request);
            byte[] outputBytes = apiString.getBytes(RouterController.UTF8_CHARSET);
            response.setContentLength(outputBytes.length);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(outputBytes);
            outputStream.flush();
        } else {
            response.setContentType(RouterController.APPLICATION_JSON.toString());
            response.setCharacterEncoding(RouterController.APPLICATION_JSON.getCharSet().name());
            String requestUrlString = request.getRequestURL().toString();
            boolean debug = requestUrlString.contains("api-debug.js");
            String routerUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "router");
            String apiString = this.buildApiJson(apiNs, actionNs, remotingApiVar, routerUrl, group, debug);
            byte[] outputBytes = apiString.getBytes(RouterController.UTF8_CHARSET);
            response.setContentLength(outputBytes.length);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(outputBytes);
            outputStream.flush();
        }
    }

    @RequestMapping(value={"/api-{fingerprint}.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false, defaultValue="Ext.app") String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false, defaultValue="REMOTING_API") String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false, defaultValue="POLLING_URLS") String pollingUrlsVar, @RequestParam(value="sseVar", required=false, defaultValue="SSE") String sseVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false, defaultValue="false") boolean fullRouterUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String apiString = this.buildAndCacheApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, sseVar, group, fullRouterUrl, request);
        byte[] outputBytes = apiString.getBytes(RouterController.UTF8_CHARSET);
        ExtDirectSpringUtil.handleCacheableResponse(request, response, outputBytes, this.routerController.getConfiguration().getJsContentType());
    }

    private String buildAndCacheApiString(String apiNs, String actionNs, String remotingApiVar, String pollingUrlsVar, String sseVar, String group, boolean fullRouterUrl, HttpServletRequest request) {
        String requestUrlString = fullRouterUrl ? request.getRequestURL().toString() : request.getRequestURI();
        if (!requestUrlString.contains("/api-debug-doc.js")) {
            boolean debug = requestUrlString.contains("api-debug.js");
            ApiCacheKey apiKey = new ApiCacheKey(apiNs, actionNs, remotingApiVar, pollingUrlsVar, sseVar, group, debug);
            String apiString = ApiCache.INSTANCE.get(apiKey);
            if (apiString == null) {
                String routerUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "router");
                String basePollUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "poll");
                String baseSseUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "sse");
                apiString = this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, sseVar, routerUrl, basePollUrl, baseSseUrl, group, debug, false);
                ApiCache.INSTANCE.put(apiKey, apiString);
            }
            return apiString;
        }
        String routerUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "router");
        String basePollUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "poll");
        String baseSseUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "sse");
        return this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, sseVar, routerUrl, basePollUrl, baseSseUrl, group, true, true);
    }

    private String buildApiString(String apiNs, String actionNs, String remotingApiVar, String pollingUrlsVar, String sseVar, String routerUrl, String basePollUrl, String baseSseUrl, String group, boolean debug, boolean doc) {
        Map<String, List<String>> sseProviders;
        String jsonConfig;
        RemotingApi remotingApi = new RemotingApi(this.routerController.getConfiguration().getProviderType(), routerUrl, actionNs);
        remotingApi.setTimeout(this.routerController.getConfiguration().getTimeout());
        remotingApi.setMaxRetries(this.routerController.getConfiguration().getMaxRetries());
        Object enableBuffer = this.routerController.getConfiguration().getEnableBuffer();
        if (enableBuffer instanceof String && StringUtils.hasText((String)((String)enableBuffer))) {
            String enableBufferString = (String)enableBuffer;
            if (enableBufferString.equalsIgnoreCase("true")) {
                remotingApi.setEnableBuffer(true);
            } else if (enableBufferString.equalsIgnoreCase("false")) {
                remotingApi.setEnableBuffer(false);
            } else {
                Integer enableBufferMs = (Integer)NumberUtils.parseNumber((String)enableBufferString, Integer.class);
                remotingApi.setEnableBuffer(enableBufferMs);
            }
        } else if (enableBuffer instanceof Number || enableBuffer instanceof Boolean) {
            remotingApi.setEnableBuffer(enableBuffer);
        }
        ApiController.buildRemotingApi(remotingApi, group);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)apiNs)) {
            sb.append("Ext.ns('");
            sb.append(apiNs);
            sb.append("');");
        }
        if (debug) {
            sb.append("\n\n");
        }
        if (StringUtils.hasText((String)actionNs)) {
            sb.append("Ext.ns('");
            sb.append(actionNs);
            sb.append("');");
            if (debug) {
                sb.append("\n\n");
            }
        }
        if (!doc) {
            jsonConfig = this.routerController.getJsonHandler().writeValueAsString(remotingApi, debug);
        } else {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixInAnnotations(RemotingApi.class, RemotingApiMixin.class);
            try {
                jsonConfig = mapper.writer().withDefaultPrettyPrinter().writeValueAsString((Object)remotingApi);
            }
            catch (JsonProcessingException e) {
                jsonConfig = null;
                LogFactory.getLog(ApiController.class).info((Object)"serialize object to json", (Throwable)e);
            }
        }
        if (StringUtils.hasText((String)apiNs)) {
            sb.append(apiNs).append(".");
        }
        sb.append(remotingApiVar).append(" = ");
        sb.append(jsonConfig);
        sb.append(";");
        List<PollingProvider> pollingProviders = remotingApi.getPollingProviders();
        if (!pollingProviders.isEmpty()) {
            if (debug) {
                sb.append("\n\n");
            }
            if (StringUtils.hasText((String)apiNs)) {
                sb.append(apiNs).append(".");
            }
            sb.append(pollingUrlsVar).append(" = {");
            if (debug) {
                sb.append("\n");
            }
            for (int i = 0; i < pollingProviders.size(); ++i) {
                if (debug) {
                    sb.append("  ");
                }
                sb.append("\"");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                sb.append(" : \"").append(basePollUrl).append("/");
                sb.append(pollingProviders.get(i).getBeanName());
                sb.append("/");
                sb.append(pollingProviders.get(i).getMethod());
                sb.append("/");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                if (i >= pollingProviders.size() - 1) continue;
                sb.append(",");
                if (!debug) continue;
                sb.append("\n");
            }
            if (debug) {
                sb.append("\n");
            }
            sb.append("};");
        }
        if (!(sseProviders = remotingApi.getSseProviders()).isEmpty()) {
            if (debug) {
                sb.append("\n\n");
            }
            HashMap sseconfig = new HashMap();
            for (Map.Entry<String, List<String>> entry : sseProviders.entrySet()) {
                String bean = entry.getKey();
                HashMap<String, String> methods = new HashMap<String, String>();
                sseconfig.put(bean, methods);
                for (String method : entry.getValue()) {
                    methods.put(method, baseSseUrl + "/" + bean + "/" + method);
                }
            }
            String sseConfig = this.routerController.getJsonHandler().writeValueAsString(sseconfig, debug);
            if (StringUtils.hasText((String)apiNs)) {
                sb.append(apiNs).append(".");
            }
            sb.append(sseVar).append(" = ");
            sb.append(sseConfig);
            sb.append(";");
        }
        return sb.toString();
    }

    private String buildApiJson(String apiNs, String actionNs, String remotingApiVar, String routerUrl, String group, boolean debug) {
        RemotingApi remotingApi = new RemotingApi(this.routerController.getConfiguration().getProviderType(), routerUrl, actionNs);
        if (StringUtils.hasText((String)apiNs)) {
            remotingApi.setDescriptor(apiNs + "." + remotingApiVar);
        } else {
            remotingApi.setDescriptor(remotingApiVar);
        }
        ApiController.buildRemotingApi(remotingApi, group);
        return this.routerController.getJsonHandler().writeValueAsString(remotingApi, debug);
    }

    private static void buildRemotingApi(RemotingApi remotingApi, String group) {
        for (Map.Entry<MethodInfoCache.Key, MethodInfo> entry : MethodInfoCache.INSTANCE) {
            MethodInfo methodInfo = entry.getValue();
            if (!ApiController.isSameGroup(group, methodInfo.getGroup())) continue;
            if (methodInfo.getAction() != null) {
                remotingApi.addAction(entry.getKey().getBeanName(), methodInfo.getAction());
                continue;
            }
            if (methodInfo.getPollingProvider() != null) {
                remotingApi.addPollingProvider(methodInfo.getPollingProvider());
                continue;
            }
            remotingApi.addSseProvider(entry.getKey().getBeanName(), methodInfo.getSseMethod());
        }
    }

    private static boolean isSameGroup(String requestedGroupString, String annotationGroupString) {
        if (requestedGroupString != null) {
            if (annotationGroupString != null) {
                for (String requestedGroup : requestedGroupString.split(",")) {
                    for (String annotationGroup : annotationGroupString.split(",")) {
                        if (!ExtDirectSpringUtil.equal(requestedGroup, annotationGroup)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

