/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectFormPostResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadResult;
import ch.ralscha.extdirectspring.bean.SSEvent;
import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import ch.ralscha.extdirectspring.util.SupportedParameters;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.util.WebUtils;

@Controller
public class RouterController
implements InitializingBean,
DisposableBean {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final MediaType EVENT_STREAM = new MediaType("text", "event-stream", UTF8_CHARSET);
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json", UTF8_CHARSET);
    public static final MediaType TEXT_HTML = new MediaType("text", "html", UTF8_CHARSET);
    private static final Log log = LogFactory.getLog(RouterController.class);
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private JsonHandler jsonHandler;
    @Autowired(required=false)
    private Configuration configuration;
    @Autowired
    private ParametersResolver parametersResolver;
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public void afterPropertiesSet() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
        if (this.configuration.getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT && this.configuration.getBatchedMethodsExecutorService() == null) {
            this.configuration.setBatchedMethodsExecutorService(Executors.newFixedThreadPool(5));
        }
    }

    public void destroy() throws Exception {
        if (this.configuration.getBatchedMethodsExecutorService() != null) {
            this.configuration.getBatchedMethodsExecutorService().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    public void poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        boolean streamResponse;
        ExtDirectPollResponse directPollResponse;
        block9: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, method);
            if (methodInfo != null) {
                streamResponse = this.configuration.isStreamResponse() || methodInfo.isStreamResponse();
                try {
                    Object[] parameters = this.prepareParameters(request, response, locale, methodInfo);
                    if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                                break block9;
                            }
                        }
                        directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                        break block9;
                    }
                    directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directPollResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directPollResponse, beanName, method);
                streamResponse = this.configuration.isStreamResponse();
            }
        }
        this.writeJsonResponse(response, directPollResponse, streamResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/sse/{beanName}/{method}"})
    public void sse(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        SSEvent result;
        block22: {
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, method);
            result = null;
            if (methodInfo != null) {
                try {
                    Object[] parameters = this.prepareParameters(request, response, locale, methodInfo);
                    Object methodReturnValue = null;
                    if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                methodReturnValue = ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters);
                            }
                        } else {
                            methodReturnValue = ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters);
                        }
                    } else {
                        methodReturnValue = ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters);
                    }
                    if (methodReturnValue instanceof SSEvent) {
                        result = (SSEvent)methodReturnValue;
                    } else {
                        result = new SSEvent();
                        if (methodReturnValue != null) {
                            result.setData(methodReturnValue.toString());
                        }
                    }
                    break block22;
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    result = new SSEvent();
                    result.setEvent("error");
                    result.setData(this.configuration.getMessage(cause));
                    if (this.configuration.isSendStacktrace()) {
                        result.setComment(ExtDirectSpringUtil.getStackTrace(cause));
                    }
                    break block22;
                }
            }
            log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
            result = new SSEvent();
            result.setEvent("error");
            result.setData(this.configuration.getDefaultExceptionMessage());
            if (this.configuration.isSendStacktrace()) {
                result.setComment("Bean or Method '" + beanName + "." + method + "' not found");
            }
        }
        response.setContentType(EVENT_STREAM.toString());
        response.setCharacterEncoding(EVENT_STREAM.getCharSet().name());
        StringBuilder sb = new StringBuilder(32);
        if (StringUtils.hasText((String)result.getComment())) {
            for (String line : result.getComment().split("\\r?\\n|\\r")) {
                sb.append(":").append(line).append("\n");
            }
        }
        if (StringUtils.hasText((String)result.getId())) {
            sb.append("id:").append(result.getId()).append("\n");
        }
        if (StringUtils.hasText((String)result.getEvent())) {
            sb.append("event:").append(result.getEvent()).append("\n");
        }
        if (StringUtils.hasText((String)result.getData())) {
            for (String line : result.getData().split("\\r?\\n|\\r")) {
                sb.append("data:").append(line).append("\n");
            }
        }
        if (result.getRetry() != null) {
            sb.append("retry:").append(result.getRetry()).append("\n");
        }
        sb.append("\n");
        FileCopyUtils.copy((byte[])sb.toString().getBytes(UTF8_CHARSET), (OutputStream)response.getOutputStream());
    }

    private Object[] prepareParameters(HttpServletRequest request, HttpServletResponse response, Locale locale, MethodInfo methodInfo) {
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale) : (methodParameter.isHasRequestHeaderAnnotation() ? this.parametersResolver.resolveRequestHeader(request, methodParameter) : this.parametersResolver.resolveRequestParam(request, null, methodParameter));
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) throws IOException {
        boolean streamResponse;
        ExtDirectResponse directResponse = new ExtDirectResponse(request);
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(extAction, extMethod);
        if (methodInfo != null && methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        if (methodInfo != null && methodInfo.getHandlerMethod() != null) {
            streamResponse = this.configuration.isStreamResponse() || methodInfo.isStreamResponse();
            HandlerMethod handlerMethod = methodInfo.getHandlerMethod();
            try {
                ModelAndView modelAndView = null;
                if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        Object mutex;
                        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                        synchronized (object) {
                            modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                        }
                    } else {
                        modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                    }
                } else {
                    modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                }
                ExtDirectFormPostResult formPostResult = (ExtDirectFormPostResult)modelAndView.getModel().get("extDirectFormPostResult");
                directResponse.setResult(formPostResult.getResult());
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + extMethod), e.getCause() != null ? e.getCause() : e);
                this.handleException(directResponse, e);
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                result.put("success", false);
                directResponse.setResult(result);
            }
        } else {
            streamResponse = this.configuration.isStreamResponse();
            log.error((Object)("Error invoking method '" + extAction + "." + extMethod + "'. Method  or Bean not found"));
            this.handleMethodNotFoundError(directResponse, extAction, extMethod);
        }
        this.writeJsonResponse(response, directResponse, streamResponse, ExtDirectSpringUtil.isMultipart(request));
        return null;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    public void router(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Object requestData = this.jsonHandler.readValue((InputStream)request.getInputStream(), Object.class);
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (requestData instanceof Map) {
            directRequests.add(this.jsonHandler.convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.jsonHandler.convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        if (directRequests.size() == 1 || this.configuration.getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.SEQUENTIAL) {
            this.handleMethodCallsSequential(directRequests, request, response, locale);
        } else if (this.configuration.getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT) {
            this.handleMethodCallsConcurrent(directRequests, request, response, locale);
        }
    }

    private void handleMethodCallsConcurrent(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<Future<ExtDirectResponse>> futures = new ArrayList<Future<ExtDirectResponse>>(directRequests.size());
        for (ExtDirectRequest directRequest : directRequests) {
            Callable<ExtDirectResponse> callable = this.createMethodCallCallable(directRequest, request, response, locale);
            futures.add(this.configuration.getBatchedMethodsExecutorService().submit(callable));
        }
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>(directRequests.size());
        boolean streamResponse = this.configuration.isStreamResponse();
        for (Future future : futures) {
            try {
                ExtDirectResponse directResponse = (ExtDirectResponse)future.get();
                streamResponse = streamResponse || directResponse.isStreamResponse();
                directResponses.add(directResponse);
            }
            catch (InterruptedException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    private Callable<ExtDirectResponse> createMethodCallCallable(final ExtDirectRequest directRequest, final HttpServletRequest request, final HttpServletResponse response, final Locale locale) {
        return new Callable<ExtDirectResponse>(){

            @Override
            public ExtDirectResponse call() throws Exception {
                return RouterController.this.handleMethodCall(directRequest, request, response, locale);
            }
        };
    }

    private void handleMethodCallsSequential(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>(directRequests.size());
        boolean streamResponse = this.configuration.isStreamResponse();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = this.handleMethodCall(directRequest, request, response, locale);
            streamResponse = streamResponse || directResponse.isStreamResponse();
            directResponses.add(directResponse);
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    ExtDirectResponse handleMethodCall(ExtDirectRequest directRequest, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
        if (methodInfo != null) {
            try {
                directResponse.setStreamResponse(methodInfo.isStreamResponse());
                ExtDirectStoreReadResult<Object> result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                if (result != null) {
                    if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                        result = new ExtDirectFormLoadResult(result);
                    } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !ExtDirectStoreReadResult.class.isAssignableFrom(result.getClass()) && this.configuration.isAlwaysWrapStoreResponse()) {
                        result = result instanceof Collection ? new ExtDirectStoreReadResult((Collection)((Object)result)) : new ExtDirectStoreReadResult<Object>(result);
                    }
                    directResponse.setResult(result);
                } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    directResponse.setResult(Collections.emptyList());
                }
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                this.handleException(directResponse, e);
            }
        } else {
            log.error((Object)("Error invoking method '" + directRequest.getAction() + "." + directRequest.getMethod() + "'. Method or Bean not found"));
            this.handleMethodNotFoundError(directResponse, directRequest.getAction(), directRequest.getMethod());
        }
        return directResponse;
    }

    private void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse) throws IOException, JsonGenerationException, JsonMappingException {
        this.writeJsonResponse(response, responseObject, streamResponse, false);
    }

    public void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse, boolean isMultipart) throws IOException, JsonGenerationException, JsonMappingException {
        if (isMultipart) {
            response.setContentType(TEXT_HTML.toString());
            response.setCharacterEncoding(TEXT_HTML.getCharSet().name());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            bos.write("<html><body><textarea>".getBytes(UTF8_CHARSET));
            String responseJson = this.jsonHandler.getMapper().writeValueAsString(responseObject);
            responseJson = responseJson.replace("&quot;", "\\&quot;");
            bos.write(responseJson.getBytes(UTF8_CHARSET));
            bos.write("</textarea></body></html>".getBytes(UTF8_CHARSET));
            response.setContentLength(bos.size());
            FileCopyUtils.copy((byte[])bos.toByteArray(), (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(APPLICATION_JSON.toString());
            response.setCharacterEncoding(APPLICATION_JSON.getCharSet().name());
            ObjectMapper objectMapper = this.jsonHandler.getMapper();
            ServletOutputStream outputStream = response.getOutputStream();
            if (!streamResponse) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)bos, JsonEncoding.UTF8);
                objectMapper.writeValue(jsonGenerator, responseObject);
                response.setContentLength(bos.size());
                outputStream.write(bos.toByteArray());
                jsonGenerator.close();
            } else {
                JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
                objectMapper.writeValue(jsonGenerator, responseObject);
                jsonGenerator.close();
            }
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object[] parameters = this.parametersResolver.resolveParameters(request, response, locale, directRequest, methodInfo);
        if ((this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
    }

    private void handleException(BaseResponse response, Exception e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configuration.getMessage(cause));
        if (this.configuration.isSendStacktrace()) {
            response.setWhere(ExtDirectSpringUtil.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
    }

    private void handleMethodNotFoundError(BaseResponse response, String beanName, String methodName) {
        response.setType("exception");
        response.setMessage(this.configuration.getDefaultExceptionMessage());
        if (this.configuration.isSendStacktrace()) {
            response.setWhere("Bean or Method '" + beanName + "." + methodName + "' not found");
        } else {
            response.setWhere(null);
        }
    }
}

