/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator.association;

import ch.ralscha.extdirectspring.generator.Model;
import ch.ralscha.extdirectspring.generator.ModelAssociation;
import ch.ralscha.extdirectspring.generator.ModelAssociationType;
import ch.ralscha.extdirectspring.generator.ModelBean;
import ch.ralscha.extdirectspring.generator.ModelGenerator;
import ch.ralscha.extdirectspring.generator.association.BelongsToAssociation;
import ch.ralscha.extdirectspring.generator.association.HasManyAssociation;
import ch.ralscha.extdirectspring.generator.association.HasOneAssociation;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Field;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractAssociation {
    private final String type;
    private final String model;
    private String associationKey;
    private String foreignKey;
    private String primaryKey;

    public AbstractAssociation(String type, String model) {
        this.type = type;
        this.model = model;
    }

    public String getAssociationKey() {
        return this.associationKey;
    }

    public void setAssociationKey(String associationKey) {
        this.associationKey = associationKey;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    protected static String getModelName(Class<?> model) {
        Model modelAnnotation = model.getAnnotation(Model.class);
        if (modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value())) {
            return modelAnnotation.value();
        }
        return model.getName();
    }

    public static AbstractAssociation createAssociation(ModelAssociation associationAnnotation, ModelBean model, Field field) {
        Model associationModelAnnotation;
        ModelAssociationType type = associationAnnotation.value();
        Class<?> associationClass = associationAnnotation.model();
        if (associationClass == Object.class) {
            associationClass = field.getType();
        }
        AbstractAssociation association = type == ModelAssociationType.HAS_MANY ? new HasManyAssociation(associationClass) : (type == ModelAssociationType.BELONGS_TO ? new BelongsToAssociation(associationClass) : new HasOneAssociation(associationClass));
        association.setAssociationKey(field.getName());
        if (StringUtils.hasText((String)associationAnnotation.foreignKey())) {
            association.setForeignKey(associationAnnotation.foreignKey());
        } else if (type == ModelAssociationType.HAS_MANY) {
            association.setForeignKey(StringUtils.uncapitalize((String)field.getDeclaringClass().getSimpleName()) + "_id");
        } else if (type == ModelAssociationType.BELONGS_TO || type == ModelAssociationType.HAS_ONE) {
            association.setForeignKey(StringUtils.uncapitalize((String)associationClass.getSimpleName()) + "_id");
        }
        if (StringUtils.hasText((String)associationAnnotation.primaryKey())) {
            association.setPrimaryKey(associationAnnotation.primaryKey());
        } else if (type == ModelAssociationType.HAS_MANY && StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            association.setPrimaryKey(model.getIdProperty());
        } else if ((type == ModelAssociationType.BELONGS_TO || type == ModelAssociationType.HAS_ONE) && (associationModelAnnotation = associationClass.getAnnotation(Model.class)) != null && StringUtils.hasText((String)associationModelAnnotation.idProperty()) && !associationModelAnnotation.idProperty().equals("id")) {
            association.setPrimaryKey(associationModelAnnotation.idProperty());
        }
        if (type == ModelAssociationType.HAS_MANY) {
            HasManyAssociation hasManyAssociation = (HasManyAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "setterName"));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "getterName"));
            }
            if (associationAnnotation.autoLoad()) {
                hasManyAssociation.setAutoLoad(true);
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                hasManyAssociation.setName(associationAnnotation.name());
            } else {
                hasManyAssociation.setName(field.getName());
            }
        } else if (type == ModelAssociationType.BELONGS_TO) {
            BelongsToAssociation belongsToAssociation = (BelongsToAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                belongsToAssociation.setSetterName(associationAnnotation.setterName());
            } else {
                belongsToAssociation.setSetterName("set" + StringUtils.capitalize((String)field.getName()));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                belongsToAssociation.setGetterName(associationAnnotation.getterName());
            } else {
                belongsToAssociation.setGetterName("get" + StringUtils.capitalize((String)field.getName()));
            }
            if (associationAnnotation.autoLoad()) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "autoLoad"));
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "name"));
            }
        } else {
            HasOneAssociation hasOneAssociation = (HasOneAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                hasOneAssociation.setSetterName(associationAnnotation.setterName());
            } else {
                hasOneAssociation.setSetterName("set" + StringUtils.capitalize((String)field.getName()));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                hasOneAssociation.setGetterName(associationAnnotation.getterName());
            } else {
                hasOneAssociation.setGetterName("get" + StringUtils.capitalize((String)field.getName()));
            }
            if (associationAnnotation.autoLoad()) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "autoLoad"));
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(field, association.getType(), "name"));
            }
        }
        return association;
    }

    private static String getWarningText(Field field, String type, String propertyName) {
        String warning = "Field ";
        warning = warning + field.getDeclaringClass().getName();
        warning = warning + ".";
        warning = warning + field.getName();
        return warning + ": A '" + type + "' association does not support property '" + propertyName + "'. Property will be ignored.";
    }
}

