/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService
implements InitializingBean,
DisposableBean {
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private Configuration configuration;
    @Autowired(required=false)
    private JsonHandler jsonHandler;
    @Autowired
    private ParametersResolver parametersResolver;

    public void afterPropertiesSet() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
        if (this.configuration.getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT && this.configuration.getBatchedMethodsExecutorService() == null) {
            this.configuration.setBatchedMethodsExecutorService(Executors.newFixedThreadPool(5));
        }
    }

    public void destroy() throws Exception {
        if (this.configuration.getBatchedMethodsExecutorService() != null) {
            this.configuration.getBatchedMethodsExecutorService().shutdown();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public ParametersResolver getParametersResolver() {
        return this.parametersResolver;
    }
}

