/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import ch.ralscha.extdirectspring.generator.IncludeValidation;
import ch.ralscha.extdirectspring.generator.Model;
import ch.ralscha.extdirectspring.generator.ModelGenerator;
import ch.ralscha.extdirectspring.generator.OutputFormat;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.util.StringUtils;

@SupportedAnnotationTypes(value={"ch.ralscha.extdirectspring.generator.Model"})
@SupportedOptions(value={"outputFormat", "debug", "includeValidation"})
public class ModelAnnotationProcessor
extends AbstractProcessor {
    private static final boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;
    private static final String OPTION_OUTPUTFORMAT = "outputFormat";
    private static final String OPTION_DEBUG = "debug";
    private static final String OPTION_INCLUDEVALIDATION = "includeValidation";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return false;
        }
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                String outputFormatString = this.processingEnv.getOptions().get(OPTION_OUTPUTFORMAT);
                boolean debugOutput = !"false".equals(this.processingEnv.getOptions().get(OPTION_DEBUG));
                String includeValidationString = this.processingEnv.getOptions().get(OPTION_INCLUDEVALIDATION);
                OutputFormat outputFormat = OutputFormat.EXTJS4;
                if (StringUtils.hasText((String)outputFormatString) && OutputFormat.TOUCH2.name().equalsIgnoreCase(outputFormatString)) {
                    outputFormat = OutputFormat.TOUCH2;
                }
                IncludeValidation includeValidation = IncludeValidation.NONE;
                if (StringUtils.hasText((String)includeValidationString)) {
                    if (IncludeValidation.ALL.name().equalsIgnoreCase(includeValidationString)) {
                        includeValidation = IncludeValidation.ALL;
                    } else if (IncludeValidation.BUILTIN.name().equalsIgnoreCase(includeValidationString)) {
                        includeValidation = IncludeValidation.BUILTIN;
                    }
                }
                try {
                    String fileName;
                    TypeElement typeElement2 = (TypeElement)element;
                    String qualifiedName = typeElement2.getQualifiedName().toString();
                    Class<?> modelClass = Class.forName(qualifiedName);
                    String code = ModelGenerator.generateJavascript(modelClass, outputFormat, includeValidation, debugOutput);
                    Model modelAnnotation = element.getAnnotation(Model.class);
                    String modelName = modelAnnotation.value();
                    String packageName = "";
                    if (StringUtils.hasText((String)modelName)) {
                        int lastDot = modelName.lastIndexOf(46);
                        if (lastDot != -1) {
                            fileName = modelName.substring(lastDot + 1);
                            int firstDot = modelName.indexOf(46);
                            if (firstDot < lastDot) {
                                packageName = modelName.substring(firstDot + 1, lastDot);
                            }
                        } else {
                            fileName = modelName;
                        }
                    } else {
                        fileName = typeElement2.getSimpleName().toString();
                    }
                    FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName + ".js", new Element[0]);
                    OutputStream os = fo.openOutputStream();
                    os.write(code.getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
                    os.close();
                }
                catch (ClassNotFoundException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
        }
        return false;
    }
}

