/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class ExtDirectFormPostResult {
    private final Map<String, Object> result = new HashMap<String, Object>();

    public ExtDirectFormPostResult() {
        this.setSuccess(true);
    }

    public ExtDirectFormPostResult(boolean success) {
        this.setSuccess(success);
    }

    public ExtDirectFormPostResult(BindingResult bindingResult) {
        this.addErrors(null, null, bindingResult);
    }

    public ExtDirectFormPostResult(BindingResult bindingResult, boolean success) {
        this.addErrors(null, null, bindingResult);
        this.setSuccess(success);
    }

    public ExtDirectFormPostResult(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        this.addErrors(locale, messageSource, bindingResult);
    }

    public ExtDirectFormPostResult(Locale locale, MessageSource messageSource, BindingResult bindingResult, boolean success) {
        this.addErrors(locale, messageSource, bindingResult);
        this.setSuccess(success);
    }

    private void addErrors(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasFieldErrors()) {
            HashMap<String, ArrayList<String>> errorMap = new HashMap<String, ArrayList<String>>();
            for (FieldError fieldError : bindingResult.getFieldErrors()) {
                ArrayList<String> fieldErrors;
                String message = fieldError.getDefaultMessage();
                if (messageSource != null) {
                    Locale loc = locale != null ? locale : Locale.getDefault();
                    message = messageSource.getMessage(fieldError.getCode(), fieldError.getArguments(), loc);
                }
                if ((fieldErrors = (ArrayList<String>)errorMap.get(fieldError.getField())) == null) {
                    fieldErrors = new ArrayList<String>();
                    errorMap.put(fieldError.getField(), fieldErrors);
                }
                fieldErrors.add(message);
            }
            if (errorMap.isEmpty()) {
                this.addResultProperty("success", true);
            } else {
                this.addResultProperty("errors", errorMap);
                this.addResultProperty("success", false);
            }
        } else {
            this.setSuccess(true);
        }
    }

    public void addResultProperty(String key, Object value) {
        this.result.put(key, value);
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setSuccess(boolean flag) {
        this.result.put("success", flag);
    }
}

