/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectFormPostResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadResult;
import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.SSEHandler;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.util.WebUtils;

@Controller
public class RouterController {
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json", ExtDirectSpringUtil.UTF8_CHARSET);
    public static final MediaType TEXT_HTML = new MediaType("text", "html", ExtDirectSpringUtil.UTF8_CHARSET);
    private static final Log log = LogFactory.getLog(RouterController.class);
    @Autowired
    private RequestMappingHandlerAdapter handlerAdapter;
    @Autowired
    private SSEHandler sseHandler;
    @Autowired
    private ConfigurationService configurationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    public void poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        boolean streamResponse;
        ExtDirectPollResponse directPollResponse;
        block9: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, method);
            if (methodInfo != null) {
                streamResponse = this.configurationService.getConfiguration().isStreamResponse() || methodInfo.isStreamResponse();
                try {
                    Object[] parameters = this.configurationService.getParametersResolver().prepareParameters(request, response, locale, methodInfo);
                    if (this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                directPollResponse.setData(ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters));
                                break block9;
                            }
                        }
                        directPollResponse.setData(ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters));
                        break block9;
                    }
                    directPollResponse.setData(ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters));
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directPollResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directPollResponse, beanName, method);
                streamResponse = this.configurationService.getConfiguration().isStreamResponse();
            }
        }
        this.writeJsonResponse(response, directPollResponse, streamResponse);
    }

    @RequestMapping(value={"/sse/{beanName}/{method}"})
    public void sse(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        this.sseHandler.handle(beanName, method, request, response, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) throws IOException {
        boolean streamResponse;
        ExtDirectResponse directResponse = new ExtDirectResponse(request);
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(extAction, extMethod);
        if (methodInfo != null && methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        if (methodInfo != null && methodInfo.getHandlerMethod() != null) {
            streamResponse = this.configurationService.getConfiguration().isStreamResponse() || methodInfo.isStreamResponse();
            HandlerMethod handlerMethod = methodInfo.getHandlerMethod();
            try {
                ModelAndView modelAndView = null;
                if (this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        Object mutex;
                        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                        synchronized (object) {
                            modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                        }
                    } else {
                        modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                    }
                } else {
                    modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                }
                ExtDirectFormPostResult formPostResult = (ExtDirectFormPostResult)modelAndView.getModel().get("extDirectFormPostResult");
                directResponse.setResult(formPostResult.getResult());
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + extMethod), e.getCause() != null ? e.getCause() : e);
                this.handleException(directResponse, e);
                HashMap<String, Boolean> result = new HashMap<String, Boolean>();
                result.put("success", false);
                directResponse.setResult(result);
            }
        } else {
            streamResponse = this.configurationService.getConfiguration().isStreamResponse();
            log.error((Object)("Error invoking method '" + extAction + "." + extMethod + "'. Method  or Bean not found"));
            this.handleMethodNotFoundError(directResponse, extAction, extMethod);
        }
        this.writeJsonResponse(response, directResponse, streamResponse, ExtDirectSpringUtil.isMultipart(request));
        return null;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    public void router(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Object requestData = this.configurationService.getJsonHandler().readValue((InputStream)request.getInputStream(), Object.class);
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (requestData instanceof Map) {
            directRequests.add(this.configurationService.getJsonHandler().convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.configurationService.getJsonHandler().convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        if (directRequests.size() == 1 || this.configurationService.getConfiguration().getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.SEQUENTIAL) {
            this.handleMethodCallsSequential(directRequests, request, response, locale);
        } else if (this.configurationService.getConfiguration().getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT) {
            this.handleMethodCallsConcurrent(directRequests, request, response, locale);
        }
    }

    private void handleMethodCallsConcurrent(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<Future<ExtDirectResponse>> futures = new ArrayList<Future<ExtDirectResponse>>(directRequests.size());
        for (ExtDirectRequest directRequest : directRequests) {
            Callable<ExtDirectResponse> callable = this.createMethodCallCallable(directRequest, request, response, locale);
            futures.add(this.configurationService.getConfiguration().getBatchedMethodsExecutorService().submit(callable));
        }
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>(directRequests.size());
        boolean streamResponse = this.configurationService.getConfiguration().isStreamResponse();
        for (Future future : futures) {
            try {
                ExtDirectResponse directResponse = (ExtDirectResponse)future.get();
                streamResponse = streamResponse || directResponse.isStreamResponse();
                directResponses.add(directResponse);
            }
            catch (InterruptedException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    private Callable<ExtDirectResponse> createMethodCallCallable(final ExtDirectRequest directRequest, final HttpServletRequest request, final HttpServletResponse response, final Locale locale) {
        return new Callable<ExtDirectResponse>(){

            @Override
            public ExtDirectResponse call() throws Exception {
                return RouterController.this.handleMethodCall(directRequest, request, response, locale);
            }
        };
    }

    private void handleMethodCallsSequential(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>(directRequests.size());
        boolean streamResponse = this.configurationService.getConfiguration().isStreamResponse();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = this.handleMethodCall(directRequest, request, response, locale);
            streamResponse = streamResponse || directResponse.isStreamResponse();
            directResponses.add(directResponse);
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    ExtDirectResponse handleMethodCall(ExtDirectRequest directRequest, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
        if (methodInfo != null) {
            try {
                directResponse.setStreamResponse(methodInfo.isStreamResponse());
                ExtDirectStoreReadResult<Object> result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                if (result != null) {
                    if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                        result = new ExtDirectFormLoadResult(result);
                    } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !ExtDirectStoreReadResult.class.isAssignableFrom(result.getClass()) && this.configurationService.getConfiguration().isAlwaysWrapStoreResponse()) {
                        result = result instanceof Collection ? new ExtDirectStoreReadResult((Collection)((Object)result)) : new ExtDirectStoreReadResult<Object>(result);
                    }
                    directResponse.setResult(result);
                } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    directResponse.setResult(Collections.emptyList());
                }
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                this.handleException(directResponse, e);
            }
        } else {
            log.error((Object)("Error invoking method '" + directRequest.getAction() + "." + directRequest.getMethod() + "'. Method or Bean not found"));
            this.handleMethodNotFoundError(directResponse, directRequest.getAction(), directRequest.getMethod());
        }
        return directResponse;
    }

    public void writeJsonResponse(HttpServletRequest request, HttpServletResponse response, Object responseObject) throws IOException, JsonGenerationException, JsonMappingException {
        this.writeJsonResponse(response, responseObject, this.configurationService.getConfiguration().isStreamResponse(), ExtDirectSpringUtil.isMultipart(request));
    }

    private void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse) throws IOException, JsonGenerationException, JsonMappingException {
        this.writeJsonResponse(response, responseObject, streamResponse, false);
    }

    public void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse, boolean isMultipart) throws IOException, JsonGenerationException, JsonMappingException {
        if (isMultipart) {
            response.setContentType(TEXT_HTML.toString());
            response.setCharacterEncoding(TEXT_HTML.getCharSet().name());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            bos.write("<html><body><textarea>".getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            String responseJson = this.configurationService.getJsonHandler().getMapper().writeValueAsString(responseObject);
            responseJson = responseJson.replace("&quot;", "\\&quot;");
            bos.write(responseJson.getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            bos.write("</textarea></body></html>".getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            response.setContentLength(bos.size());
            FileCopyUtils.copy((byte[])bos.toByteArray(), (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(APPLICATION_JSON.toString());
            response.setCharacterEncoding(APPLICATION_JSON.getCharSet().name());
            ObjectMapper objectMapper = this.configurationService.getJsonHandler().getMapper();
            ServletOutputStream outputStream = response.getOutputStream();
            if (!streamResponse) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                JsonGenerator jsonGenerator = objectMapper.getFactory().createJsonGenerator((OutputStream)bos, JsonEncoding.UTF8);
                objectMapper.writeValue(jsonGenerator, responseObject);
                response.setContentLength(bos.size());
                outputStream.write(bos.toByteArray());
                jsonGenerator.close();
            } else {
                JsonGenerator jsonGenerator = objectMapper.getFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
                objectMapper.writeValue(jsonGenerator, responseObject);
                jsonGenerator.close();
            }
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object[] parameters = this.configurationService.getParametersResolver().resolveParameters(request, response, locale, directRequest, methodInfo);
        if ((this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), directRequest.getAction(), methodInfo, parameters);
    }

    private void handleException(BaseResponse response, Exception e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configurationService.getConfiguration().getMessage(cause));
        if (this.configurationService.getConfiguration().isSendStacktrace()) {
            response.setWhere(ExtDirectSpringUtil.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
    }

    private void handleMethodNotFoundError(BaseResponse response, String beanName, String methodName) {
        response.setType("exception");
        response.setMessage(this.configurationService.getConfiguration().getDefaultExceptionMessage());
        if (this.configurationService.getConfiguration().isSendStacktrace()) {
            response.setWhere("Bean or Method '" + beanName + "." + methodName + "' not found");
        } else {
            response.setWhere(null);
        }
    }
}

