/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
class ProxyObjectWithoutQuotes {
    private final String type = "direct";
    private String idParam;
    @JsonRawValue
    private String directFn;
    private ApiObject api;
    private ReaderObject reader;

    public ProxyObjectWithoutQuotes(String idParam, String read, String create, String update, String destroy, boolean paging) {
        if (StringUtils.hasText((String)idParam) && !idParam.equals("id")) {
            this.idParam = idParam;
        }
        boolean hasApiMethods = false;
        ApiObject apiObject = new ApiObject();
        if (StringUtils.hasText((String)create)) {
            hasApiMethods = true;
            apiObject.create = create;
        }
        if (StringUtils.hasText((String)update)) {
            hasApiMethods = true;
            apiObject.update = update;
        }
        if (StringUtils.hasText((String)destroy)) {
            hasApiMethods = true;
            apiObject.destroy = destroy;
        }
        if (StringUtils.hasText((String)read)) {
            if (hasApiMethods) {
                apiObject.read = read;
            } else {
                this.directFn = read;
            }
        }
        if (hasApiMethods) {
            this.api = apiObject;
        }
        if (paging) {
            this.reader = new ReaderObject();
        }
    }

    public boolean hasMethods() {
        return this.api != null || this.directFn != null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private final class ReaderObject {
        private final String root = "records";

        private ReaderObject() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final class ApiObject {
        @JsonRawValue
        private String read;
        @JsonRawValue
        private String create;
        @JsonRawValue
        private String update;
        @JsonRawValue
        private String destroy;

        private ApiObject() {
        }
    }
}

