/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import ch.ralscha.extdirectspring.generator.ModelFieldBean;
import ch.ralscha.extdirectspring.generator.association.AbstractAssociation;
import ch.ralscha.extdirectspring.generator.validation.AbstractValidation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class ModelBean {
    private String name;
    private String idProperty;
    private Map<String, ModelFieldBean> fields = new LinkedHashMap<String, ModelFieldBean>();
    private List<AbstractValidation> validations = new ArrayList<AbstractValidation>();
    private List<AbstractAssociation> associations = new ArrayList<AbstractAssociation>();
    private boolean paging;
    private String readMethod;
    private String createMethod;
    private String updateMethod;
    private String destroyMethod;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdProperty() {
        return this.idProperty;
    }

    public void setIdProperty(String idProperty) {
        this.idProperty = idProperty;
    }

    public Map<String, ModelFieldBean> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, ModelFieldBean> fields) {
        this.fields = fields;
    }

    public List<AbstractValidation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<AbstractValidation> validations) {
        this.validations = validations;
    }

    public List<AbstractAssociation> getAssociations() {
        return this.associations;
    }

    public void setAssociations(List<AbstractAssociation> associations) {
        this.associations = associations;
    }

    public void addFields(List<ModelFieldBean> modelFields) {
        Assert.notNull(modelFields, (String)"modelFields must not be null");
        for (ModelFieldBean bean : modelFields) {
            this.fields.put(bean.getName(), bean);
        }
    }

    public void addValidations(List<AbstractValidation> fieldValidations) {
        Assert.notNull(fieldValidations, (String)"fieldValidations must not be null");
        this.validations.addAll(fieldValidations);
    }

    public void addAssociations(List<AbstractAssociation> associationsList) {
        Assert.notNull(associationsList, (String)"associations must not be null");
        this.associations.addAll(associationsList);
    }

    public ModelFieldBean getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public void addField(ModelFieldBean bean) {
        Assert.notNull((Object)bean, (String)"ModelFieldBean must not be null");
        this.fields.put(bean.getName(), bean);
    }

    public void addValidation(AbstractValidation bean) {
        Assert.notNull((Object)bean, (String)"ModelFieldValidationBean must not be null");
        this.validations.add(bean);
    }

    public void addAssociation(AbstractAssociation bean) {
        Assert.notNull((Object)bean, (String)"AbstractAssociation must not be null");
        this.associations.add(bean);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }

    public String getReadMethod() {
        return this.readMethod;
    }

    public void setReadMethod(String readMethod) {
        this.readMethod = readMethod;
    }

    public String getCreateMethod() {
        return this.createMethod;
    }

    public void setCreateMethod(String createMethod) {
        this.createMethod = createMethod;
    }

    public String getUpdateMethod() {
        return this.updateMethod;
    }

    public void setUpdateMethod(String updateMethod) {
        this.updateMethod = updateMethod;
    }

    public String getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(String destroyMethod) {
        this.destroyMethod = destroyMethod;
    }
}

