/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import ch.ralscha.extdirectspring.generator.ModelBean;
import ch.ralscha.extdirectspring.generator.OutputConfig;
import ch.ralscha.extdirectspring.generator.OutputFormat;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.Map;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
class ProxyObjectWithQuotes {
    private final String type = "direct";
    private String idParam;
    private String directFn;
    private ApiObject api;
    private Map<String, String> reader;

    public ProxyObjectWithQuotes(ModelBean model, OutputConfig config) {
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            this.idParam = model.getIdProperty();
        }
        boolean hasApiMethods = false;
        ApiObject apiObject = new ApiObject();
        if (StringUtils.hasText((String)model.getCreateMethod())) {
            hasApiMethods = true;
            apiObject.create = model.getCreateMethod();
        }
        if (StringUtils.hasText((String)model.getUpdateMethod())) {
            hasApiMethods = true;
            apiObject.update = model.getUpdateMethod();
        }
        if (StringUtils.hasText((String)model.getDestroyMethod())) {
            hasApiMethods = true;
            apiObject.destroy = model.getDestroyMethod();
        }
        if (StringUtils.hasText((String)model.getReadMethod())) {
            if (hasApiMethods) {
                apiObject.read = model.getReadMethod();
            } else {
                this.directFn = model.getReadMethod();
            }
        }
        if (hasApiMethods) {
            this.api = apiObject;
        }
        if (model.isPaging()) {
            String rootPropertyName = config.getOutputFormat() == OutputFormat.EXTJS4 ? "root" : "rootProperty";
            this.reader = Collections.singletonMap(rootPropertyName, "records");
        }
    }

    public boolean hasMethods() {
        return this.api != null || this.directFn != null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final class ApiObject {
        private String read;
        private String create;
        private String update;
        private String destroy;

        private ApiObject() {
        }
    }
}

