/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.RouterExceptionHandler;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;

public class DefaultRouterExceptionHandler
implements RouterExceptionHandler {
    private final ConfigurationService configurationService;

    public DefaultRouterExceptionHandler(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @Override
    public Object handleException(MethodInfo methodInfo, BaseResponse response, Exception e, HttpServletRequest request) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configurationService.getConfiguration().getMessage(cause));
        if (this.configurationService.getConfiguration().isSendStacktrace()) {
            response.setWhere(ExtDirectSpringUtil.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
        if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
            return Collections.singletonMap("success", false);
        }
        return null;
    }
}

