/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class ExtDirectFormPostResult {
    private static final String ERRORS_PROPERTY = "errors";
    private static final String SUCCESS_PROPERTY = "success";
    private final Map<String, Object> result = new HashMap<String, Object>();

    public ExtDirectFormPostResult() {
        this.setSuccess(true);
    }

    public ExtDirectFormPostResult(boolean success) {
        this.setSuccess(success);
    }

    public ExtDirectFormPostResult(BindingResult bindingResult) {
        this.addErrors(null, null, bindingResult);
    }

    public ExtDirectFormPostResult(BindingResult bindingResult, boolean success) {
        this.addErrors(null, null, bindingResult);
        this.setSuccess(success);
    }

    public ExtDirectFormPostResult(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        this.addErrors(locale, messageSource, bindingResult);
    }

    public ExtDirectFormPostResult(Locale locale, MessageSource messageSource, BindingResult bindingResult, boolean success) {
        this.addErrors(locale, messageSource, bindingResult);
        this.setSuccess(success);
    }

    private void addErrors(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasFieldErrors()) {
            HashMap<String, ArrayList<String>> errorMap = new HashMap<String, ArrayList<String>>();
            for (FieldError fieldError : bindingResult.getFieldErrors()) {
                ArrayList<String> fieldErrors;
                String message = fieldError.getDefaultMessage();
                if (messageSource != null) {
                    Locale loc = locale != null ? locale : Locale.getDefault();
                    message = messageSource.getMessage(fieldError.getCode(), fieldError.getArguments(), loc);
                }
                if ((fieldErrors = (ArrayList<String>)errorMap.get(fieldError.getField())) == null) {
                    fieldErrors = new ArrayList<String>();
                    errorMap.put(fieldError.getField(), fieldErrors);
                }
                fieldErrors.add(message);
            }
            if (errorMap.isEmpty()) {
                this.addResultProperty(SUCCESS_PROPERTY, true);
            } else {
                this.addResultProperty(ERRORS_PROPERTY, errorMap);
                this.addResultProperty(SUCCESS_PROPERTY, false);
            }
        } else {
            this.setSuccess(true);
        }
    }

    public void addError(String field, String error) {
        Assert.notNull((Object)field, (String)"field must not be null");
        Assert.notNull((Object)error, (String)"field must not be null");
        this.addErrors(field, Collections.singletonList(error));
        this.addResultProperty(SUCCESS_PROPERTY, false);
    }

    public void addErrors(String field, List<String> errors) {
        ArrayList<String> fieldErrors;
        Assert.notNull((Object)field, (String)"field must not be null");
        Assert.notNull(errors, (String)"field must not be null");
        HashMap<String, ArrayList<String>> errorMap = (HashMap<String, ArrayList<String>>)this.result.get(ERRORS_PROPERTY);
        if (errorMap == null) {
            errorMap = new HashMap<String, ArrayList<String>>();
            this.addResultProperty(ERRORS_PROPERTY, errorMap);
        }
        if ((fieldErrors = (ArrayList<String>)errorMap.get(field)) == null) {
            fieldErrors = new ArrayList<String>();
            errorMap.put(field, fieldErrors);
        }
        fieldErrors.addAll(errors);
        this.addResultProperty(SUCCESS_PROPERTY, false);
    }

    public void addResultProperty(String key, Object value) {
        this.result.put(key, value);
    }

    public Map<String, Object> getResult() {
        return this.result;
    }

    public void setSuccess(boolean flag) {
        this.result.put(SUCCESS_PROPERTY, flag);
    }
}

