/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Action {
    private final String name;
    private final Integer len;
    private final List<String> params;
    private final Boolean formHandler;

    public Action(String name, Integer len, Boolean formHandler) {
        this.name = name;
        this.len = len;
        this.formHandler = formHandler;
        this.params = null;
    }

    public Action(String name, List<String> params) {
        this.name = name;
        this.len = null;
        this.formHandler = null;
        this.params = new ArrayList<String>(params);
    }

    public Action(Action toCopy) {
        this.name = toCopy.name;
        this.len = toCopy.len;
        this.formHandler = toCopy.formHandler;
        this.params = toCopy.params;
    }

    public Boolean isFormHandler() {
        return this.formHandler;
    }

    public Integer getLen() {
        return this.len;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParams() {
        if (this.params != null) {
            return Collections.unmodifiableList(this.params);
        }
        return null;
    }
}

