/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import ch.ralscha.extdirectspring.generator.IncludeValidation;
import ch.ralscha.extdirectspring.generator.JsCacheKey;
import ch.ralscha.extdirectspring.generator.Model;
import ch.ralscha.extdirectspring.generator.ModelAssociation;
import ch.ralscha.extdirectspring.generator.ModelBean;
import ch.ralscha.extdirectspring.generator.ModelCacheKey;
import ch.ralscha.extdirectspring.generator.ModelField;
import ch.ralscha.extdirectspring.generator.ModelFieldBean;
import ch.ralscha.extdirectspring.generator.ModelType;
import ch.ralscha.extdirectspring.generator.OutputConfig;
import ch.ralscha.extdirectspring.generator.OutputFormat;
import ch.ralscha.extdirectspring.generator.ProxyObjectWithQuotes;
import ch.ralscha.extdirectspring.generator.ProxyObjectWithoutQuotes;
import ch.ralscha.extdirectspring.generator.association.AbstractAssociation;
import ch.ralscha.extdirectspring.generator.validation.AbstractValidation;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ModelGenerator {
    private static final Map<JsCacheKey, SoftReference<String>> jsCache = new ConcurrentHashMap<JsCacheKey, SoftReference<String>>();
    private static final Map<ModelCacheKey, SoftReference<ModelBean>> modelCache = new ConcurrentHashMap<ModelCacheKey, SoftReference<ModelBean>>();

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, clazz, format, IncludeValidation.NONE, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format, boolean debug) throws IOException {
        ModelGenerator.writeModel(request, response, clazz, format, IncludeValidation.NONE, debug);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format, IncludeValidation includeValidation, boolean debug) throws IOException {
        ModelBean model = ModelGenerator.createModel(clazz, includeValidation);
        ModelGenerator.writeModel(request, response, model, format, debug);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputConfig outputConfig) throws IOException {
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        ModelGenerator.writeModel(request, response, model, outputConfig);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, model, format, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format, boolean debug) throws IOException {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setDebug(debug);
        outputConfig.setOutputFormat(format);
        ModelGenerator.writeModel(request, response, model, outputConfig);
    }

    public static ModelBean createModel(Class<?> clazz) {
        return ModelGenerator.createModel(clazz, IncludeValidation.NONE);
    }

    public static ModelBean createModel(Class<?> clazz, IncludeValidation includeValidation) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setIncludeValidation(includeValidation);
        return ModelGenerator.createModel(clazz, outputConfig);
    }

    public static String generateJavascript(Class<?> clazz, OutputFormat format, boolean debug) {
        ModelBean model = ModelGenerator.createModel(clazz, IncludeValidation.NONE);
        return ModelGenerator.generateJavascript(model, format, debug);
    }

    public static String generateJavascript(Class<?> clazz, OutputConfig outputConfig) {
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static String generateJavascript(Class<?> clazz, OutputFormat format, IncludeValidation includeValidation, boolean debug) {
        ModelBean model = ModelGenerator.createModel(clazz, includeValidation);
        return ModelGenerator.generateJavascript(model, format, debug);
    }

    public static String generateJavascript(ModelBean model, OutputFormat format, boolean debug) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setOutputFormat(format);
        outputConfig.setDebug(debug);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputConfig outputConfig) throws IOException {
        byte[] data = ModelGenerator.generateJavascript(model, outputConfig).getBytes(ExtDirectSpringUtil.UTF8_CHARSET);
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = "\"0" + DigestUtils.md5DigestAsHex((byte[])data) + "\"";
        if (etag.equals(ifNoneMatch)) {
            response.setStatus(304);
            return;
        }
        response.setContentType("application/javascript");
        response.setCharacterEncoding(ExtDirectSpringUtil.UTF8_CHARSET.name());
        response.setContentLength(data.length);
        response.setHeader("ETag", etag);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }

    public static ModelBean createModel(Class<?> clazz, final OutputConfig outputConfig) {
        BeanInfo bi;
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)((Object)outputConfig.getIncludeValidation()), (String)"includeValidation must not be null");
        ModelCacheKey key = new ModelCacheKey(clazz.getName(), outputConfig.getIncludeValidation());
        SoftReference<ModelBean> modelReference = modelCache.get(key);
        if (modelReference != null && modelReference.get() != null) {
            return modelReference.get();
        }
        Model modelAnnotation = clazz.getAnnotation(Model.class);
        final ModelBean model = new ModelBean();
        if (modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value())) {
            model.setName(modelAnnotation.value());
        } else {
            model.setName(clazz.getName());
        }
        if (modelAnnotation != null) {
            model.setIdProperty(modelAnnotation.idProperty());
            model.setPaging(modelAnnotation.paging());
            if (StringUtils.hasText((String)modelAnnotation.createMethod())) {
                model.setCreateMethod(modelAnnotation.createMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.readMethod())) {
                model.setReadMethod(modelAnnotation.readMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.updateMethod())) {
                model.setUpdateMethod(modelAnnotation.updateMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.destroyMethod())) {
                model.setDestroyMethod(modelAnnotation.destroyMethod());
            }
            if (StringUtils.hasText((String)modelAnnotation.messageProperty())) {
                model.setMessageProperty(modelAnnotation.messageProperty());
            }
        }
        final HashSet<String> hasReadMethod = new HashSet<String>();
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            if (pd.getReadMethod() == null || pd.getReadMethod().getAnnotation(JsonIgnore.class) != null) continue;
            hasReadMethod.add(pd.getName());
        }
        final ArrayList<ModelFieldBean> modelFields = new ArrayList<ModelFieldBean>();
        final ArrayList<AbstractAssociation> associations = new ArrayList<AbstractAssociation>();
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){
            private final Set<String> fields = new HashSet<String>();

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (!this.fields.contains(field.getName()) && (field.getAnnotation(ModelField.class) != null || field.getAnnotation(ModelAssociation.class) != null || (Modifier.isPublic(field.getModifiers()) || hasReadMethod.contains(field.getName())) && field.getAnnotation(JsonIgnore.class) == null)) {
                    this.fields.add(field.getName());
                    Class<?> javaType = field.getType();
                    ModelType modelType = null;
                    for (ModelType mt : ModelType.values()) {
                        if (!mt.supports(javaType)) continue;
                        modelType = mt;
                        break;
                    }
                    ModelFieldBean modelFieldBean = null;
                    ModelField modelFieldAnnotation = field.getAnnotation(ModelField.class);
                    if (modelFieldAnnotation != null) {
                        String defaultValue;
                        String name = StringUtils.hasText((String)modelFieldAnnotation.value()) ? modelFieldAnnotation.value() : field.getName();
                        ModelType type = modelFieldAnnotation.type() != ModelType.AUTO ? modelFieldAnnotation.type() : (modelType != null ? modelType : ModelType.AUTO);
                        modelFieldBean = new ModelFieldBean(name, type);
                        if (StringUtils.hasText((String)modelFieldAnnotation.dateFormat()) && type == ModelType.DATE) {
                            modelFieldBean.setDateFormat(modelFieldAnnotation.dateFormat());
                        }
                        if (StringUtils.hasText((String)(defaultValue = modelFieldAnnotation.defaultValue()))) {
                            if ("undefined".equals(defaultValue)) {
                                modelFieldBean.setDefaultValue("undefined");
                            } else if (type == ModelType.BOOLEAN) {
                                modelFieldBean.setDefaultValue(Boolean.parseBoolean(defaultValue));
                            } else if (type == ModelType.INTEGER) {
                                modelFieldBean.setDefaultValue(Long.valueOf(defaultValue));
                            } else if (type == ModelType.FLOAT) {
                                modelFieldBean.setDefaultValue(Double.valueOf(defaultValue));
                            } else {
                                modelFieldBean.setDefaultValue("\"" + defaultValue + "\"");
                            }
                        }
                        if (modelFieldAnnotation.useNull() && (type == ModelType.INTEGER || type == ModelType.FLOAT || type == ModelType.STRING || type == ModelType.BOOLEAN)) {
                            modelFieldBean.setUseNull(true);
                        }
                        if (StringUtils.hasText((String)modelFieldAnnotation.mapping())) {
                            modelFieldBean.setMapping(modelFieldAnnotation.mapping());
                        }
                        if (!modelFieldAnnotation.persist()) {
                            modelFieldBean.setPersist(modelFieldAnnotation.persist());
                        }
                        if (StringUtils.hasText((String)modelFieldAnnotation.convert())) {
                            modelFieldBean.setConvert(modelFieldAnnotation.convert());
                        }
                        modelFields.add(modelFieldBean);
                    } else if (modelType != null) {
                        modelFieldBean = new ModelFieldBean(field.getName(), modelType);
                        modelFields.add(modelFieldBean);
                    }
                    ModelAssociation modelAssociationAnnotation = field.getAnnotation(ModelAssociation.class);
                    if (modelAssociationAnnotation != null) {
                        associations.add(AbstractAssociation.createAssociation(modelAssociationAnnotation, model, field));
                    }
                    if (modelFieldBean != null && outputConfig.getIncludeValidation() != IncludeValidation.NONE) {
                        Annotation[] fieldAnnotations;
                        for (Annotation fieldAnnotation : fieldAnnotations = field.getAnnotations()) {
                            AbstractValidation.addValidationToModel(model, modelFieldBean, fieldAnnotation, outputConfig.getIncludeValidation());
                        }
                    }
                }
            }
        });
        model.addFields(modelFields);
        model.addAssociations(associations);
        modelCache.put(key, new SoftReference<ModelBean>(model));
        return model;
    }

    public static String generateJavascript(ModelBean model, OutputConfig config) {
        String configObjectString;
        Object proxyObject;
        JsCacheKey key;
        SoftReference<String> jsReference;
        if (!config.isDebug() && (jsReference = jsCache.get(key = new JsCacheKey(model, config))) != null && jsReference.get() != null) {
            return jsReference.get();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        LinkedHashMap<String, Object> modelObject = new LinkedHashMap<String, Object>();
        modelObject.put("extend", "Ext.data.Model");
        if (!model.getAssociations().isEmpty()) {
            HashSet<String> usesClasses = new HashSet<String>();
            for (AbstractAssociation association : model.getAssociations()) {
                usesClasses.add(association.getModel());
            }
            usesClasses.remove(model.getName());
            if (!usesClasses.isEmpty()) {
                modelObject.put("uses", usesClasses);
            }
        }
        LinkedHashMap<String, Object> configObject = new LinkedHashMap<String, Object>();
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            configObject.put("idProperty", model.getIdProperty());
        }
        configObject.put("fields", model.getFields().values());
        if (!model.getAssociations().isEmpty()) {
            configObject.put("associations", model.getAssociations());
        }
        if (!model.getValidations().isEmpty()) {
            configObject.put("validations", model.getValidations());
        }
        if (config.isSurroundApiWithQuotes()) {
            proxyObject = new ProxyObjectWithQuotes(model, config);
            if (((ProxyObjectWithQuotes)proxyObject).hasMethods()) {
                configObject.put("proxy", proxyObject);
            }
        } else {
            proxyObject = new ProxyObjectWithoutQuotes(model, config);
            if (((ProxyObjectWithoutQuotes)proxyObject).hasMethods()) {
                configObject.put("proxy", proxyObject);
            }
        }
        if (config.getOutputFormat() == OutputFormat.EXTJS4) {
            modelObject.putAll(configObject);
        } else {
            modelObject.put("config", configObject);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Ext.define(\"").append(model.getName()).append("\",");
        if (config.isDebug()) {
            sb.append("\n");
        }
        try {
            configObjectString = config.isDebug() ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(modelObject) : mapper.writeValueAsString(modelObject);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sb.append(configObjectString);
        sb.append(");");
        String result = sb.toString();
        if (config.isUseSingleQuotes()) {
            result = result.replace('\"', '\'');
        }
        if (!config.isDebug()) {
            jsCache.put(new JsCacheKey(model, config), new SoftReference<String>(result));
        }
        return result;
    }

    public static void clearCaches() {
        modelCache.clear();
        jsCache.clear();
    }
}

