/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public enum Comparison {
    LESS_THAN("lt", "<"),
    LESS_THAN_OR_EQUAL("lte", "<="),
    GREATER_THAN("gt", ">"),
    GREATER_THAN_OR_EQUAL("gte", ">="),
    EQUAL("eq", "="),
    NOT_EQUAL("ne", "!="),
    LIKE("like"),
    IN("in");

    private final Set<String> externalValues = new HashSet<String>();

    private Comparison(String ... values) {
        Collections.addAll(this.externalValues, values);
    }

    public boolean is(String externalValue) {
        return this.externalValues.contains(externalValue);
    }

    public static Comparison fromString(String externalValue) {
        if (externalValue != null) {
            String externalValueLowerCase = externalValue.toLowerCase();
            for (Comparison comparison : Comparison.values()) {
                if (!comparison.is(externalValueLowerCase)) continue;
                return comparison;
            }
        }
        throw new NoSuchElementException("Comparison value: '" + externalValue + "' not supported");
    }
}

