/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import ch.ralscha.extdirectspring.filter.BooleanFilter;
import ch.ralscha.extdirectspring.filter.Comparison;
import ch.ralscha.extdirectspring.filter.DateFilter;
import ch.ralscha.extdirectspring.filter.ListFilter;
import ch.ralscha.extdirectspring.filter.NumericFilter;
import ch.ralscha.extdirectspring.filter.StringFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

public class Filter {
    private final String field;
    private final Comparison comparison;

    public Filter(String field, Comparison comparison) {
        this.field = field;
        this.comparison = comparison;
    }

    public String getField() {
        return this.field;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public static Filter createFilter(Map<String, Object> jsonData, ConversionService conversionService) {
        String type = (String)jsonData.get("type");
        Object source = jsonData.get("value");
        if (type == null) {
            String property = (String)jsonData.get("property");
            if (property != null) {
                if (source instanceof Number) {
                    return new NumericFilter(property, (Number)source, null);
                }
                if (source instanceof Boolean) {
                    return new BooleanFilter(property, (Boolean)source, null);
                }
                return new StringFilter(property, source != null ? source.toString() : null, null);
            }
            return null;
        }
        String field = (String)jsonData.get("field");
        if (field == null) {
            field = (String)jsonData.get("property");
        }
        if (type.equals("numeric") || type.equals("int") || type.equals("float") || type.equals("number")) {
            Number value = (Number)conversionService.convert(source, Number.class);
            return new NumericFilter(field, value, Filter.getComparison(jsonData));
        }
        if (type.equals("string")) {
            return new StringFilter(field, (String)source, Filter.getComparison(jsonData));
        }
        if (type.equals("date")) {
            return new DateFilter(field, (String)source, Filter.getComparison(jsonData));
        }
        if (type.equals("list") || type.equals("combo")) {
            if (source instanceof String) {
                String[] values = ((String)source).split(",");
                return new ListFilter(field, Arrays.asList(values), Filter.getComparison(jsonData));
            }
            return new ListFilter(field, (List)source, Filter.getComparison(jsonData));
        }
        if (type.equals("boolean")) {
            return new BooleanFilter(field, (Boolean)source, Filter.getComparison(jsonData));
        }
        return null;
    }

    private static Comparison getComparison(Map<String, Object> jsonData) {
        String comparison = (String)jsonData.get("comparison");
        if (comparison == null) {
            comparison = (String)jsonData.get("operator");
        }
        if (comparison != null) {
            return Comparison.fromString(comparison);
        }
        return null;
    }
}

