/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.SupportedParameters;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public final class ParameterInfo {
    private static final DefaultParameterNameDiscoverer discoverer = new DefaultParameterNameDiscoverer();
    private String name;
    private final TypeDescriptor typeDescriptor;
    private final boolean supportedParameter;
    private boolean hasRequestParamAnnotation;
    private boolean hasRequestHeaderAnnotation;
    private boolean hasCookieValueAnnotation;
    private Boolean hasAuthenticationPrincipalAnnotation;
    private boolean required;
    private String defaultValue;

    public ParameterInfo(Class<?> clazz, Method method, int paramIndex) {
        Annotation[] paramAnnotations;
        MethodParameter methodParam = new MethodParameter(method, paramIndex);
        methodParam.initParameterNameDiscovery((ParameterNameDiscoverer)discoverer);
        GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, clazz);
        this.name = methodParam.getParameterName();
        this.typeDescriptor = new TypeDescriptor(methodParam);
        this.supportedParameter = SupportedParameters.isSupported(this.typeDescriptor.getObjectType());
        for (Annotation paramAnn : paramAnnotations = methodParam.getParameterAnnotations()) {
            this.hasRequestParamAnnotation = false;
            this.hasRequestHeaderAnnotation = false;
            this.hasCookieValueAnnotation = false;
            this.hasAuthenticationPrincipalAnnotation = null;
            if (RequestParam.class.isInstance(paramAnn)) {
                RequestParam requestParam = (RequestParam)paramAnn;
                if (StringUtils.hasText((String)requestParam.value())) {
                    this.name = requestParam.value();
                }
                this.required = requestParam.required();
                this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue()) ? null : requestParam.defaultValue();
                this.hasRequestParamAnnotation = true;
                break;
            }
            if (RequestHeader.class.isInstance(paramAnn)) {
                RequestHeader requestHeader = (RequestHeader)paramAnn;
                if (StringUtils.hasText((String)requestHeader.value())) {
                    this.name = requestHeader.value();
                }
                this.required = requestHeader.required();
                this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestHeader.defaultValue()) ? null : requestHeader.defaultValue();
                this.hasRequestHeaderAnnotation = true;
                break;
            }
            if (CookieValue.class.isInstance(paramAnn)) {
                CookieValue cookieValue = (CookieValue)paramAnn;
                if (StringUtils.hasText((String)cookieValue.value())) {
                    this.name = cookieValue.value();
                }
                this.required = cookieValue.required();
                this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(cookieValue.defaultValue()) ? null : cookieValue.defaultValue();
                this.hasCookieValueAnnotation = true;
                break;
            }
            if (!paramAnn.annotationType().getName().equals("org.springframework.security.web.bind.annotation.AuthenticationPrincipal")) continue;
            this.hasAuthenticationPrincipalAnnotation = (Boolean)AnnotationUtils.getValue((Annotation)paramAnn, (String)"errorOnInvalidType");
        }
    }

    public Class<?> getType() {
        return this.typeDescriptor.getType();
    }

    public Class<?> getCollectionType() {
        if (this.typeDescriptor.isCollection() && this.typeDescriptor.getElementTypeDescriptor() != null) {
            return this.typeDescriptor.getElementTypeDescriptor().getType();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasRequestParamAnnotation() {
        return this.hasRequestParamAnnotation;
    }

    public boolean hasRequestHeaderAnnotation() {
        return this.hasRequestHeaderAnnotation;
    }

    public boolean hasCookieValueAnnotation() {
        return this.hasCookieValueAnnotation;
    }

    public boolean hasAuthenticationPrincipalAnnotation() {
        return this.hasAuthenticationPrincipalAnnotation != null;
    }

    public boolean authenticationPrincipalAnnotationErrorOnInvalidType() {
        return this.hasAuthenticationPrincipalAnnotation != null ? this.hasAuthenticationPrincipalAnnotation : false;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSupportedParameter() {
        return this.supportedParameter;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public boolean isClientParameter() {
        return !this.isSupportedParameter() && !this.hasRequestHeaderAnnotation() && !this.hasCookieValueAnnotation() && !this.hasAuthenticationPrincipalAnnotation();
    }
}

