/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.controller.SSEWriter;
import java.security.Principal;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

enum SupportedParameters {
    SERVLET_REQUEST(ServletRequest.class),
    SERVLET_RESPONSE(ServletResponse.class),
    SESSION(HttpSession.class),
    LOCALE(Locale.class),
    PRINCIPAL(Principal.class),
    SSE_WRITER(SSEWriter.class);

    private final Class<?> clazz;

    private SupportedParameters(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getSupportedClass() {
        return this.clazz;
    }

    public static boolean isSupported(Class<?> clazz) {
        if (clazz != null) {
            for (SupportedParameters supportedParameter : SupportedParameters.values()) {
                if (!supportedParameter.clazz.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object resolveParameter(Class<?> parameterType, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        return SupportedParameters.resolveParameter(parameterType, request, response, locale, null);
    }

    public static Object resolveParameter(Class<?> parameterType, HttpServletRequest request, HttpServletResponse response, Locale locale, SSEWriter sseWriter) {
        if (SERVLET_REQUEST.getSupportedClass().isAssignableFrom(parameterType)) {
            return request;
        }
        if (SERVLET_RESPONSE.getSupportedClass().isAssignableFrom(parameterType)) {
            return response;
        }
        if (SESSION.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getSession();
        }
        if (PRINCIPAL.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (LOCALE.getSupportedClass().equals(parameterType)) {
            return locale;
        }
        if (SSE_WRITER.getSupportedClass().equals(parameterType)) {
            return sseWriter;
        }
        return null;
    }
}

