/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Action {
    private final String name;
    private final Integer len;
    private final List<String> params;
    private final Boolean formHandler;
    private final Boolean strict;
    private final Metadata metadata;

    public Action(String name, Integer len) {
        this(name, len, null, null, null, null);
    }

    public Action(String name, Integer len, Boolean formHandler) {
        this(name, len, formHandler, null, null, null);
    }

    public Action(String name, Integer len, List<String> metadataParams) {
        this(name, len, null, null, null, metadataParams);
    }

    public Action(String name, List<String> params) {
        this(name, null, null, params, null, null);
    }

    public Action(String name, List<String> params, Boolean strict) {
        this(name, null, null, params, strict, null);
    }

    Action(String name, Integer len, Boolean formHandler, List<String> params, Boolean strict, List<String> metadataParams) {
        this.name = name;
        this.len = len;
        this.formHandler = formHandler != null && formHandler != false ? formHandler : null;
        this.params = params != null ? params : null;
        this.strict = strict != null && strict == false ? strict : null;
        this.metadata = metadataParams != null && !metadataParams.isEmpty() ? new Metadata(metadataParams) : null;
    }

    public Action(Action toCopy) {
        this.name = toCopy.name;
        this.len = toCopy.len;
        this.formHandler = toCopy.formHandler;
        this.params = toCopy.params;
        this.strict = toCopy.strict;
        this.metadata = toCopy.metadata;
    }

    public Boolean isFormHandler() {
        return this.formHandler;
    }

    public Integer getLen() {
        return this.len;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParams() {
        return this.params;
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    class Metadata {
        private final List<String> params;

        Metadata(List<String> params) {
            this.params = params;
        }

        public List<String> getParams() {
            return this.params;
        }
    }
}

