/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.bean.SSEvent;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.SSEWriter;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.util.WebUtils;

@Service
public class SSEHandler {
    private static final Log log = LogFactory.getLog(SSEHandler.class);
    private final ConfigurationService configurationService;
    private final MethodInfoCache methodInfoCache;

    @Autowired
    public SSEHandler(ConfigurationService configurationService, MethodInfoCache methodInfoCache) {
        this.configurationService = configurationService;
        this.methodInfoCache = methodInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String beanName, String method, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        SSEWriter sseWriter;
        SSEvent result;
        block16: {
            MethodInfo methodInfo = this.methodInfoCache.get(beanName, method);
            result = null;
            sseWriter = new SSEWriter(response);
            if (methodInfo != null) {
                try {
                    Object methodReturnValue;
                    Object[] parameters = this.configurationService.getParametersResolver().prepareParameters(request, response, locale, methodInfo, sseWriter);
                    if (this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                methodReturnValue = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                            }
                        } else {
                            methodReturnValue = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                        }
                    } else {
                        methodReturnValue = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                    }
                    if (methodReturnValue instanceof SSEvent) {
                        result = (SSEvent)methodReturnValue;
                    } else if (methodReturnValue != null) {
                        result = new SSEvent();
                        result.setData(methodReturnValue.toString());
                    }
                    break block16;
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    Throwable cause = e.getCause() != null ? e.getCause() : e;
                    result = new SSEvent();
                    result.setEvent("error");
                    result.setData(this.configurationService.getConfiguration().getMessage(cause));
                    if (this.configurationService.getConfiguration().isSendStacktrace()) {
                        result.setComment(ExtDirectSpringUtil.getStackTrace(cause));
                    }
                    break block16;
                }
            }
            log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
            result = new SSEvent();
            result.setEvent("error");
            result.setData(this.configurationService.getConfiguration().getDefaultExceptionMessage());
            if (this.configurationService.getConfiguration().isSendStacktrace()) {
                result.setComment("Bean or Method '" + beanName + "." + method + "' not found");
            }
        }
        if (result != null) {
            sseWriter.write(result);
        }
    }
}

