/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.bean.SSEvent;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class SSEWriter {
    private final HttpServletResponse response;
    private static final MediaType EVENT_STREAM = new MediaType("text", "event-stream", ExtDirectSpringUtil.UTF8_CHARSET);

    public SSEWriter(HttpServletResponse response) {
        this.response = response;
        response.setContentType(EVENT_STREAM.toString());
        response.setCharacterEncoding(EVENT_STREAM.getCharSet().name());
    }

    public void write(Object data) throws IOException {
        if (data != null) {
            SSEvent sseEvent = new SSEvent();
            sseEvent.setData(data.toString());
            this.write(sseEvent);
        }
    }

    public void write(SSEvent sseEvent) throws IOException {
        StringBuilder sb = new StringBuilder(32);
        if (StringUtils.hasText((String)sseEvent.getComment())) {
            for (String line : sseEvent.getComment().split("\\r?\\n|\\r")) {
                sb.append(":").append(line).append("\n");
            }
        }
        if (StringUtils.hasText((String)sseEvent.getId())) {
            sb.append("id:").append(sseEvent.getId()).append("\n");
        }
        if (StringUtils.hasText((String)sseEvent.getEvent())) {
            sb.append("event:").append(sseEvent.getEvent()).append("\n");
        }
        if (StringUtils.hasText((String)sseEvent.getData())) {
            for (String line : sseEvent.getData().split("\\r?\\n|\\r")) {
                sb.append("data:").append(line).append("\n");
            }
        }
        if (sseEvent.getRetry() != null) {
            sb.append("retry:").append(sseEvent.getRetry()).append("\n");
        }
        sb.append("\n");
        this.response.getOutputStream().write(sb.toString().getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
        this.response.getOutputStream().flush();
    }
}

