/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.GroupInfo;
import ch.ralscha.extdirectspring.bean.SortDirection;
import ch.ralscha.extdirectspring.bean.SortInfo;
import ch.ralscha.extdirectspring.filter.Filter;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameters;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public final class ParametersResolver {
    private static final Log log = LogFactory.getLog(ParametersResolver.class);
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private final ConversionService conversionService;
    private final JsonHandler jsonHandler;
    private final Collection<WebArgumentResolver> webArgumentResolvers;
    private final Expression getPrincipalExpression = new SpelExpressionParser().parseExpression("T(org.springframework.security.core.context.SecurityContextHolder).getContext().getAuthentication()?.getPrincipal()");
    private static Object javaUtilOptionalEmpty = null;

    public ParametersResolver(ConversionService conversionService, JsonHandler jsonHandler, Collection<WebArgumentResolver> webArgumentResolvers) {
        this.conversionService = conversionService;
        this.jsonHandler = jsonHandler;
        this.webArgumentResolvers = webArgumentResolvers;
    }

    public Object[] prepareParameters(HttpServletRequest request, HttpServletResponse response, Locale locale, MethodInfo methodInfo) {
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale) : (methodParameter.hasRequestHeaderAnnotation() ? this.resolveRequestHeader(request, methodParameter) : (methodParameter.hasCookieValueAnnotation() ? this.resolveCookieValue(request, methodParameter) : (methodParameter.hasAuthenticationPrincipalAnnotation() ? this.resolveAuthenticationPrincipal(methodParameter) : this.resolveRequestParam(request, null, methodParameter))));
            }
        }
        return parameters;
    }

    public Object[] resolveParameters(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        Object obj;
        Object data;
        int jsonParamIndex = 0;
        Map<String, Object> remainingParameters = null;
        ExtDirectStoreReadRequest extDirectStoreReadRequest = null;
        List<Object> directStoreModifyRecords = null;
        if (methodInfo.isType(ExtDirectMethodType.STORE_READ) || methodInfo.isType(ExtDirectMethodType.FORM_LOAD) || methodInfo.isType(ExtDirectMethodType.TREE_LOAD)) {
            data = (List)directRequest.getData();
            if (data != null && data.size() > 0) {
                if (methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    extDirectStoreReadRequest = new ExtDirectStoreReadRequest();
                    remainingParameters = this.fillReadRequestFromMap(extDirectStoreReadRequest, (Map)data.get(0));
                } else {
                    remainingParameters = (Map<String, Object>)data.get(0);
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY)) {
            Class<?> directStoreEntryClass = methodInfo.getCollectionType();
            data = (List)directRequest.getData();
            if (directStoreEntryClass != null && data != null && data.size() > 0) {
                obj = data.get(0);
                if (obj instanceof List) {
                    directStoreModifyRecords = this.convertObjectEntriesToType((List)obj, directStoreEntryClass);
                } else {
                    Map jsonData = (Map)obj;
                    Object records = jsonData.get("records");
                    if (records != null) {
                        if (records instanceof List) {
                            directStoreModifyRecords = this.convertObjectEntriesToType((List)records, directStoreEntryClass);
                        } else {
                            directStoreModifyRecords = new ArrayList<Object>();
                            directStoreModifyRecords.add(this.jsonHandler.convertValue(records, directStoreEntryClass));
                        }
                        remainingParameters = new HashMap<String, Object>(jsonData);
                        remainingParameters.remove("records");
                    } else {
                        directStoreModifyRecords = new ArrayList<Object>();
                        directStoreModifyRecords.add(this.jsonHandler.convertValue((Object)jsonData, directStoreEntryClass));
                    }
                }
                jsonParamIndex = 1;
            } else if (data != null && data.size() > 0 && (obj = data.get(0)) instanceof Map) {
                remainingParameters = new HashMap<String, Object>((Map)obj);
                remainingParameters.remove("records");
            }
        } else if (methodInfo.isType(ExtDirectMethodType.SIMPLE_NAMED)) {
            data = (Map)directRequest.getData();
            if (data != null && data.size() > 0) {
                remainingParameters = new HashMap<String, Object>((Map<String, Object>)data);
            }
        } else {
            if (methodInfo.isType(ExtDirectMethodType.POLL)) {
                throw new IllegalStateException("this controller does not handle poll calls");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
                throw new IllegalStateException("this controller does not handle form posts");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST_JSON) && (data = (List)directRequest.getData()) != null && data.size() > 0 && (obj = data.get(0)) instanceof Map) {
                remainingParameters = new HashMap<String, Object>((Map)obj);
                remainingParameters.remove("records");
            }
        }
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                Object jsonValue;
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                if (methodParameter.isSupportedParameter()) {
                    parameters[paramIndex] = SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale);
                    continue;
                }
                if (ExtDirectStoreReadRequest.class.isAssignableFrom(methodParameter.getType())) {
                    parameters[paramIndex] = extDirectStoreReadRequest;
                    continue;
                }
                if (directStoreModifyRecords != null && methodParameter.getCollectionType() != null) {
                    parameters[paramIndex] = directStoreModifyRecords;
                    continue;
                }
                if (methodParameter.hasRequestParamAnnotation()) {
                    parameters[paramIndex] = this.resolveRequestParam(null, remainingParameters, methodParameter);
                    continue;
                }
                if (methodParameter.hasMetadataParamAnnotation()) {
                    parameters[paramIndex] = this.resolveRequestParam(null, directRequest.getMetadata(), methodParameter);
                    continue;
                }
                if (methodParameter.hasRequestHeaderAnnotation()) {
                    parameters[paramIndex] = this.resolveRequestHeader(request, methodParameter);
                    continue;
                }
                if (methodParameter.hasCookieValueAnnotation()) {
                    parameters[paramIndex] = this.resolveCookieValue(request, methodParameter);
                    continue;
                }
                if (methodParameter.hasAuthenticationPrincipalAnnotation()) {
                    parameters[paramIndex] = this.resolveAuthenticationPrincipal(methodParameter);
                    continue;
                }
                if (remainingParameters != null && remainingParameters.containsKey(methodParameter.getName())) {
                    jsonValue = remainingParameters.get(methodParameter.getName());
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    continue;
                }
                if (directRequest.getData() != null && directRequest.getData() instanceof List && ((List)directRequest.getData()).size() > jsonParamIndex) {
                    jsonValue = ((List)directRequest.getData()).get(jsonParamIndex);
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    ++jsonParamIndex;
                    continue;
                }
                if (methodInfo.isType(ExtDirectMethodType.SIMPLE_NAMED)) {
                    if (Map.class.isAssignableFrom(methodParameter.getType())) {
                        parameters[paramIndex] = remainingParameters;
                        continue;
                    }
                    if (methodParameter.isJavaUtilOptional()) {
                        parameters[paramIndex] = javaUtilOptionalEmpty;
                        continue;
                    }
                }
                log.info((Object)("WebResolvers size:" + this.webArgumentResolvers.size()));
                log.info((Object)("ParamIndex:" + paramIndex));
                log.info((Object)("Request params size:" + request.getParameterMap().isEmpty()));
                log.info((Object)("Request params names:" + request.getParameterMap().keySet()));
                log.info((Object)("Direct Request:" + directRequest.toString()));
                MethodParameter p = new MethodParameter(methodInfo.getMethod(), paramIndex);
                request.setAttribute("directRequest", (Object)directRequest);
                request.setAttribute("extDirectStoreReadRequest", (Object)extDirectStoreReadRequest);
                ServletWebRequest r = new ServletWebRequest(request);
                Object result = WebArgumentResolver.UNRESOLVED;
                for (WebArgumentResolver resolver : this.webArgumentResolvers) {
                    log.info((Object)("Resolving with:" + resolver.getClass().getCanonicalName()));
                    result = resolver.resolveArgument(p, (NativeWebRequest)r);
                    if (result == WebArgumentResolver.UNRESOLVED) continue;
                    log.info((Object)("Resolved by:" + resolver.getClass().getCanonicalName()));
                    parameters[paramIndex] = result;
                    break;
                }
                if (result != WebArgumentResolver.UNRESOLVED) continue;
                throw new IllegalArgumentException("Error, parameter mismatch. Please check your remoting method signature to ensure all supported parameters types are used.");
            }
        }
        return parameters;
    }

    private Object resolveRequestParam(HttpServletRequest request, Map<String, Object> valueContainer, ParameterInfo parameterInfo) {
        if (parameterInfo.getName() != null) {
            Object value = request != null ? request.getParameter(parameterInfo.getName()) : (valueContainer != null ? valueContainer.get(parameterInfo.getName()) : null);
            if (value == null) {
                value = parameterInfo.getDefaultValue();
            }
            if (value != null) {
                return this.convertValue(value, parameterInfo);
            }
            if (parameterInfo.isJavaUtilOptional()) {
                return javaUtilOptionalEmpty;
            }
            if (parameterInfo.isRequired()) {
                throw new IllegalStateException("Missing parameter '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
            }
        }
        return null;
    }

    private Object resolveRequestHeader(HttpServletRequest request, ParameterInfo parameterInfo) {
        String value = request.getHeader(parameterInfo.getName());
        if (value == null) {
            value = parameterInfo.getDefaultValue();
        }
        if (value != null) {
            return this.convertValue(value, parameterInfo);
        }
        if (parameterInfo.isJavaUtilOptional()) {
            return javaUtilOptionalEmpty;
        }
        if (parameterInfo.isRequired()) {
            throw new IllegalStateException("Missing header '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
        }
        return null;
    }

    private Object resolveCookieValue(HttpServletRequest request, ParameterInfo parameterInfo) {
        Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)request, (String)parameterInfo.getName());
        String value = null;
        value = cookieValue != null ? this.urlPathHelper.decodeRequestString(request, cookieValue.getValue()) : parameterInfo.getDefaultValue();
        if (value != null) {
            return this.convertValue(value, parameterInfo);
        }
        if (parameterInfo.isJavaUtilOptional()) {
            return javaUtilOptionalEmpty;
        }
        if (parameterInfo.isRequired()) {
            throw new IllegalStateException("Missing cookie '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
        }
        return null;
    }

    private Object resolveAuthenticationPrincipal(ParameterInfo parameterInfo) {
        Object principal = this.getPrincipalExpression.getValue();
        if (principal != null && !parameterInfo.getType().isAssignableFrom(principal.getClass())) {
            if (parameterInfo.authenticationPrincipalAnnotationErrorOnInvalidType()) {
                throw new ClassCastException(principal + " is not assignable to " + parameterInfo.getType());
            }
            return null;
        }
        return principal;
    }

    private Object convertValue(Object value, ParameterInfo methodParameter) {
        if (value != null) {
            if (methodParameter.getType().equals(value.getClass())) {
                return value;
            }
            if (this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor())) {
                try {
                    return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor());
                }
                catch (ConversionFailedException e) {
                    TypeFactory typeFactory = this.jsonHandler.getMapper().getTypeFactory();
                    if (methodParameter.getTypeDescriptor().isCollection()) {
                        CollectionType type = CollectionType.construct(methodParameter.getType(), (JavaType)typeFactory.constructType((Type)methodParameter.getTypeDescriptor().getElementTypeDescriptor().getType()));
                        return this.jsonHandler.convertValue(value, (JavaType)type);
                    }
                    if (methodParameter.getTypeDescriptor().isArray()) {
                        ArrayType type = typeFactory.constructArrayType(methodParameter.getTypeDescriptor().getElementTypeDescriptor().getType());
                        return this.jsonHandler.convertValue(value, (JavaType)type);
                    }
                    throw e;
                }
            }
            return this.jsonHandler.convertValue(value, methodParameter.getType());
        }
        if (methodParameter.isJavaUtilOptional()) {
            return javaUtilOptionalEmpty;
        }
        return null;
    }

    private Map<String, Object> fillReadRequestFromMap(ExtDirectStoreReadRequest to, Map<String, Object> from) {
        HashSet<String> foundParameters = new HashSet<String>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("filter")) {
                Filter filter;
                ArrayList<Filter> filters = new ArrayList<Filter>();
                if (value instanceof String) {
                    List<Map<String, Object>> rawFilters = this.jsonHandler.readValue((String)value, new TypeReference<List<Map<String, Object>>>(){});
                    for (Map map : rawFilters) {
                        filter = Filter.createFilter(map, this.conversionService);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                } else if (value instanceof List) {
                    List filterList = (List)value;
                    for (Map map : filterList) {
                        filter = Filter.createFilter(map, this.conversionService);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                }
                to.setFilters(filters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("sort") && value != null && value instanceof List) {
                ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
                List rawSorters = (List)value;
                for (Map map : rawSorters) {
                    sorters.add(SortInfo.create(map));
                }
                to.setSorters(sorters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("group") && value != null && value instanceof List) {
                ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
                List rawGroups = (List)value;
                for (Map map : rawGroups) {
                    groups.add(GroupInfo.create(map));
                }
                to.setGroups(groups);
                foundParameters.add(key);
                continue;
            }
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(to.getClass(), (String)key);
            if (descriptor == null || descriptor.getWriteMethod() == null) continue;
            try {
                descriptor.getWriteMethod().invoke((Object)to, this.conversionService.convert(value, descriptor.getPropertyType()));
                foundParameters.add(key);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
        }
        if (to.getLimit() != null) {
            if (to.getPage() != null && to.getStart() == null) {
                to.setStart(to.getLimit() * (to.getPage() - 1));
            } else if (to.getPage() == null && to.getStart() != null) {
                to.setPage(to.getStart() / to.getLimit() + 1);
            }
        }
        if (to.getSort() != null && to.getDir() != null) {
            ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
            sorters.add(new SortInfo(to.getSort(), SortDirection.fromString(to.getDir())));
            to.setSorters(sorters);
        }
        if (to.getGroupBy() != null && to.getGroupDir() != null) {
            ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
            groups.add(new GroupInfo(to.getGroupBy(), SortDirection.fromString(to.getGroupDir())));
            to.setGroups(groups);
        }
        HashMap<String, Object> remainingParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (foundParameters.contains(entry.getKey())) continue;
            remainingParameters.put(entry.getKey(), entry.getValue());
        }
        to.setParams(remainingParameters);
        return remainingParameters;
    }

    private List<Object> convertObjectEntriesToType(List<Object> records, Class<?> directStoreType) {
        if (records != null) {
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : records) {
                Object convertedObject = this.jsonHandler.convertValue(record, directStoreType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return null;
    }

    static {
        try {
            Class clazz = ClassUtils.forName((String)"java.util.Optional", (ClassLoader)ParametersResolver.class.getClassLoader());
            javaUtilOptionalEmpty = ClassUtils.getMethod((Class)clazz, (String)"empty", (Class[])new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

