/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.EdJsonStoreResult;
import ch.ralscha.extdirectspring.bean.MetaData;
import ch.ralscha.extdirectspring.bean.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

final class ImmutableEdJsonStoreResult
extends EdJsonStoreResult {
    private final Collection<String> records;
    @Nullable
    private final Long total;
    @Nullable
    private final Boolean success;
    @Nullable
    private final MetaData metaData;
    @Nullable
    private final String message;

    private ImmutableEdJsonStoreResult(Collection<String> records, @Nullable Long total, @Nullable Boolean success, @Nullable MetaData metaData, @Nullable String message) {
        this.records = Objects.requireNonNull(records, "records");
        this.total = total;
        this.success = success;
        this.metaData = metaData;
        this.message = message;
    }

    private ImmutableEdJsonStoreResult(ImmutableEdJsonStoreResult original, Collection<String> records, @Nullable Long total, @Nullable Boolean success, @Nullable MetaData metaData, @Nullable String message) {
        this.records = records;
        this.total = total;
        this.success = success;
        this.metaData = metaData;
        this.message = message;
    }

    @Override
    @JsonProperty(value="records")
    @JsonSerialize(using=EdJsonStoreResult.CollectionStringSerializer.class)
    public Collection<String> records() {
        return this.records;
    }

    @Override
    @JsonProperty(value="total")
    @Nullable
    public Long total() {
        return this.total;
    }

    @Override
    @JsonProperty(value="success")
    @Nullable
    public Boolean success() {
        return this.success;
    }

    @Override
    @JsonProperty(value="metaData")
    @Nullable
    public MetaData metaData() {
        return this.metaData;
    }

    @Override
    @JsonProperty(value="message")
    @Nullable
    public String message() {
        return this.message;
    }

    public final ImmutableEdJsonStoreResult withRecords(Collection<String> records) {
        if (this.records == records) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(records, "records");
        return new ImmutableEdJsonStoreResult(this, newValue, this.total, this.success, this.metaData, this.message);
    }

    public final ImmutableEdJsonStoreResult withTotal(@Nullable Long total) {
        if (Objects.equals(this.total, total)) {
            return this;
        }
        return new ImmutableEdJsonStoreResult(this, this.records, total, this.success, this.metaData, this.message);
    }

    public final ImmutableEdJsonStoreResult withSuccess(@Nullable Boolean success) {
        if (Objects.equals(this.success, success)) {
            return this;
        }
        return new ImmutableEdJsonStoreResult(this, this.records, this.total, success, this.metaData, this.message);
    }

    public final ImmutableEdJsonStoreResult withMetaData(@Nullable MetaData metaData) {
        if (this.metaData == metaData) {
            return this;
        }
        return new ImmutableEdJsonStoreResult(this, this.records, this.total, this.success, metaData, this.message);
    }

    public final ImmutableEdJsonStoreResult withMessage(@Nullable String message) {
        if (Objects.equals(this.message, message)) {
            return this;
        }
        return new ImmutableEdJsonStoreResult(this, this.records, this.total, this.success, this.metaData, message);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEdJsonStoreResult && this.equalTo((ImmutableEdJsonStoreResult)another);
    }

    private boolean equalTo(ImmutableEdJsonStoreResult another) {
        return this.records.equals(another.records) && Objects.equals(this.total, another.total) && Objects.equals(this.success, another.success) && Objects.equals(this.metaData, another.metaData) && Objects.equals(this.message, another.message);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.records.hashCode();
        h = h * 17 + Objects.hashCode(this.total);
        h = h * 17 + Objects.hashCode(this.success);
        h = h * 17 + Objects.hashCode(this.metaData);
        h = h * 17 + Objects.hashCode(this.message);
        return h;
    }

    public String toString() {
        return "EdJsonStoreResult{records=" + this.records + ", total=" + this.total + ", success=" + this.success + ", metaData=" + this.metaData + ", message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableEdJsonStoreResult fromJson(Json json) {
        EdJsonStoreResult.Builder builder = new EdJsonStoreResult.Builder();
        if (json.records != null) {
            builder.records(json.records);
        }
        if (json.total != null) {
            builder.total(json.total);
        }
        if (json.success != null) {
            builder.success(json.success);
        }
        if (json.metaData != null) {
            builder.metaData(json.metaData);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static ImmutableEdJsonStoreResult of(Collection<String> records, @Nullable Long total, @Nullable Boolean success, @Nullable MetaData metaData, @Nullable String message) {
        return new ImmutableEdJsonStoreResult(records, total, success, metaData, message);
    }

    public static ImmutableEdJsonStoreResult copyOf(EdJsonStoreResult instance) {
        if (instance instanceof ImmutableEdJsonStoreResult) {
            return (ImmutableEdJsonStoreResult)instance;
        }
        return new EdJsonStoreResult.Builder().from(instance).build();
    }

    static class Builder {
        private static final long INIT_BIT_RECORDS = 1L;
        private long initBits = 1L;
        private Collection<String> records;
        private Long total;
        private Boolean success;
        private MetaData metaData;
        private String message;

        Builder() {
            if (!(this instanceof EdJsonStoreResult.Builder)) {
                throw new UnsupportedOperationException("Use: new EdJsonStoreResult.Builder()");
            }
        }

        public final EdJsonStoreResult.Builder from(EdJsonStoreResult instance) {
            String messageValue;
            MetaData metaDataValue;
            Boolean successValue;
            Objects.requireNonNull(instance, "instance");
            this.records(instance.records());
            Long totalValue = instance.total();
            if (totalValue != null) {
                this.total(totalValue);
            }
            if ((successValue = instance.success()) != null) {
                this.success(successValue);
            }
            if ((metaDataValue = instance.metaData()) != null) {
                this.metaData(metaDataValue);
            }
            if ((messageValue = instance.message()) != null) {
                this.message(messageValue);
            }
            return (EdJsonStoreResult.Builder)this;
        }

        public final EdJsonStoreResult.Builder records(Collection<String> records) {
            this.records = Objects.requireNonNull(records, "records");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (EdJsonStoreResult.Builder)this;
        }

        public final EdJsonStoreResult.Builder total(@Nullable Long total) {
            this.total = total;
            return (EdJsonStoreResult.Builder)this;
        }

        public final EdJsonStoreResult.Builder success(@Nullable Boolean success) {
            this.success = success;
            return (EdJsonStoreResult.Builder)this;
        }

        public final EdJsonStoreResult.Builder metaData(@Nullable MetaData metaData) {
            this.metaData = metaData;
            return (EdJsonStoreResult.Builder)this;
        }

        public final EdJsonStoreResult.Builder message(@Nullable String message) {
            this.message = message;
            return (EdJsonStoreResult.Builder)this;
        }

        public ImmutableEdJsonStoreResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEdJsonStoreResult(null, this.records, this.total, this.success, this.metaData, this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("records");
            }
            return "Cannot build EdJsonStoreResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends EdJsonStoreResult {
        Collection<String> records;
        Long total;
        Boolean success;
        MetaData metaData;
        String message;

        Json() {
        }

        @JsonProperty(value="records")
        @JsonSerialize(using=EdJsonStoreResult.CollectionStringSerializer.class)
        public void setRecords(Collection<String> records) {
            this.records = records;
        }

        @JsonProperty(value="total")
        public void setTotal(@Nullable Long total) {
            this.total = total;
        }

        @JsonProperty(value="success")
        public void setSuccess(@Nullable Boolean success) {
            this.success = success;
        }

        @JsonProperty(value="metaData")
        public void setMetaData(@Nullable MetaData metaData) {
            this.metaData = metaData;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @Override
        public Collection<String> records() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long total() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean success() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MetaData metaData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }
    }
}

