package ch.ralscha.extdirectspring.bean;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link EdJsonStoreResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new EdJsonStoreResult.Builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdJsonStoreResult.of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "EdJsonStoreResult"})
final class ImmutableEdJsonStoreResult extends EdJsonStoreResult {
  private final Collection<String> records;
  private final @Nullable Long total;
  private final @Nullable Boolean success;
  private final @Nullable MetaData metaData;
  private final @Nullable String message;

  private ImmutableEdJsonStoreResult(
      Collection<String> records,
      @Nullable Long total,
      @Nullable Boolean success,
      @Nullable MetaData metaData,
      @Nullable String message) {
    this.records = Objects.requireNonNull(records, "records");
    this.total = total;
    this.success = success;
    this.metaData = metaData;
    this.message = message;
  }

  private ImmutableEdJsonStoreResult(
      ImmutableEdJsonStoreResult original,
      Collection<String> records,
      @Nullable Long total,
      @Nullable Boolean success,
      @Nullable MetaData metaData,
      @Nullable String message) {
    this.records = records;
    this.total = total;
    this.success = success;
    this.metaData = metaData;
    this.message = message;
  }

  /**
   * @return The value of the {@code records} attribute
   */
  @JsonProperty("records")
  @JsonSerialize(using = EdJsonStoreResult.CollectionStringSerializer.class)
  @Override
  public Collection<String> records() {
    return records;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty("total")
  @Override
  public @Nullable Long total() {
    return total;
  }

  /**
   * @return The value of the {@code success} attribute
   */
  @JsonProperty("success")
  @Override
  public @Nullable Boolean success() {
    return success;
  }

  /**
   * @return The value of the {@code metaData} attribute
   */
  @JsonProperty("metaData")
  @Override
  public @Nullable MetaData metaData() {
    return metaData;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdJsonStoreResult#records() records} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for records
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdJsonStoreResult withRecords(Collection<String> value) {
    if (this.records == value) return this;
    Collection<String> newValue = Objects.requireNonNull(value, "records");
    return new ImmutableEdJsonStoreResult(this, newValue, this.total, this.success, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdJsonStoreResult#total() total} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for total (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdJsonStoreResult withTotal(@Nullable Long value) {
    if (Objects.equals(this.total, value)) return this;
    return new ImmutableEdJsonStoreResult(this, this.records, value, this.success, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdJsonStoreResult#success() success} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for success (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdJsonStoreResult withSuccess(@Nullable Boolean value) {
    if (Objects.equals(this.success, value)) return this;
    return new ImmutableEdJsonStoreResult(this, this.records, this.total, value, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdJsonStoreResult#metaData() metaData} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metaData (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdJsonStoreResult withMetaData(@Nullable MetaData value) {
    if (this.metaData == value) return this;
    return new ImmutableEdJsonStoreResult(this, this.records, this.total, this.success, value, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdJsonStoreResult#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdJsonStoreResult withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableEdJsonStoreResult(this, this.records, this.total, this.success, this.metaData, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdJsonStoreResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdJsonStoreResult
        && equalTo((ImmutableEdJsonStoreResult) another);
  }

  private boolean equalTo(ImmutableEdJsonStoreResult another) {
    return records.equals(another.records)
        && Objects.equals(total, another.total)
        && Objects.equals(success, another.success)
        && Objects.equals(metaData, another.metaData)
        && Objects.equals(message, another.message);
  }

  /**
   * Computes a hash code from attributes: {@code records}, {@code total}, {@code success}, {@code metaData}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + records.hashCode();
    h = h * 17 + Objects.hashCode(total);
    h = h * 17 + Objects.hashCode(success);
    h = h * 17 + Objects.hashCode(metaData);
    h = h * 17 + Objects.hashCode(message);
    return h;
  }

  /**
   * Prints the immutable value {@code EdJsonStoreResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EdJsonStoreResult{"
        + "records=" + records
        + ", total=" + total
        + ", success=" + success
        + ", metaData=" + metaData
        + ", message=" + message
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends EdJsonStoreResult {
    Collection<String> records;
    Long total;
    Boolean success;
    MetaData metaData;
    String message;
    @JsonProperty("records")
    @JsonSerialize(using = EdJsonStoreResult.CollectionStringSerializer.class)
    public void setRecords(Collection<String> records) {
      this.records = records;
    }
    @JsonProperty("total")
    public void setTotal(@Nullable Long total) {
      this.total = total;
    }
    @JsonProperty("success")
    public void setSuccess(@Nullable Boolean success) {
      this.success = success;
    }
    @JsonProperty("metaData")
    public void setMetaData(@Nullable MetaData metaData) {
      this.metaData = metaData;
    }
    @JsonProperty("message")
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @Override
    public Collection<String> records() { throw new UnsupportedOperationException(); }
    @Override
    public Long total() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean success() { throw new UnsupportedOperationException(); }
    @Override
    public MetaData metaData() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEdJsonStoreResult fromJson(Json json) {
    EdJsonStoreResult.Builder builder = new EdJsonStoreResult.Builder();
    if (json.records != null) {
      builder.records(json.records);
    }
    if (json.total != null) {
      builder.total(json.total);
    }
    if (json.success != null) {
      builder.success(json.success);
    }
    if (json.metaData != null) {
      builder.metaData(json.metaData);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code EdJsonStoreResult} instance.
   * @param records The value for the {@code records} attribute
   * @param total The value for the {@code total} attribute
   * @param success The value for the {@code success} attribute
   * @param metaData The value for the {@code metaData} attribute
   * @param message The value for the {@code message} attribute
   * @return An immutable EdJsonStoreResult instance
   */
  public static ImmutableEdJsonStoreResult of(Collection<String> records, @Nullable Long total, @Nullable Boolean success, @Nullable MetaData metaData, @Nullable String message) {
    return new ImmutableEdJsonStoreResult(records, total, success, metaData, message);
  }

  /**
   * Creates an immutable copy of a {@link EdJsonStoreResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EdJsonStoreResult instance
   */
  public static ImmutableEdJsonStoreResult copyOf(EdJsonStoreResult instance) {
    if (instance instanceof ImmutableEdJsonStoreResult) {
      return (ImmutableEdJsonStoreResult) instance;
    }
    return new EdJsonStoreResult.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableEdJsonStoreResult ImmutableEdJsonStoreResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static class Builder {
    private static final long INIT_BIT_RECORDS = 0x1L;
    private long initBits = 0x1L;

    private Collection<String> records;
    private Long total;
    private Boolean success;
    private MetaData metaData;
    private String message;

    /**
     * Creates a builder for {@link ImmutableEdJsonStoreResult ImmutableEdJsonStoreResult} instances.
     */
    Builder() {
      if (!(this instanceof EdJsonStoreResult.Builder)) {
        throw new UnsupportedOperationException("Use: new EdJsonStoreResult.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code EdJsonStoreResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final EdJsonStoreResult.Builder from(EdJsonStoreResult instance) {
      Objects.requireNonNull(instance, "instance");
      records(instance.records());
      @Nullable Long totalValue = instance.total();
      if (totalValue != null) {
        total(totalValue);
      }
      @Nullable Boolean successValue = instance.success();
      if (successValue != null) {
        success(successValue);
      }
      @Nullable MetaData metaDataValue = instance.metaData();
      if (metaDataValue != null) {
        metaData(metaDataValue);
      }
      @Nullable String messageValue = instance.message();
      if (messageValue != null) {
        message(messageValue);
      }
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Initializes the value for the {@link EdJsonStoreResult#records() records} attribute.
     * @param records The value for records 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("records")
    public final EdJsonStoreResult.Builder records(Collection<String> records) {
      this.records = Objects.requireNonNull(records, "records");
      initBits &= ~INIT_BIT_RECORDS;
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Initializes the value for the {@link EdJsonStoreResult#total() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total")
    public final EdJsonStoreResult.Builder total(@Nullable Long total) {
      this.total = total;
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Initializes the value for the {@link EdJsonStoreResult#success() success} attribute.
     * @param success The value for success (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("success")
    public final EdJsonStoreResult.Builder success(@Nullable Boolean success) {
      this.success = success;
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Initializes the value for the {@link EdJsonStoreResult#metaData() metaData} attribute.
     * @param metaData The value for metaData (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metaData")
    public final EdJsonStoreResult.Builder metaData(@Nullable MetaData metaData) {
      this.metaData = metaData;
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Initializes the value for the {@link EdJsonStoreResult#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final EdJsonStoreResult.Builder message(@Nullable String message) {
      this.message = message;
      return (EdJsonStoreResult.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableEdJsonStoreResult ImmutableEdJsonStoreResult}.
     * @return An immutable instance of EdJsonStoreResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdJsonStoreResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEdJsonStoreResult(null, records, total, success, metaData, message);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_RECORDS) != 0) attributes.add("records");
      return "Cannot build EdJsonStoreResult, some of required attributes are not set " + attributes;
    }
  }
}
