/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.EdStoreResult;
import ch.ralscha.extdirectspring.bean.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

final class ImmutableEdStoreResult<T>
extends EdStoreResult<T> {
    private final Collection<T> records;
    @Nullable
    private final Long total;
    @Nullable
    private final Boolean success;
    @Nullable
    private final Map<String, Object> metaData;
    @Nullable
    private final String message;

    private ImmutableEdStoreResult(Collection<T> records, @Nullable Long total, @Nullable Boolean success, @Nullable Map<String, ? extends Object> metaData, @Nullable String message) {
        this.records = Objects.requireNonNull(records, "records");
        this.total = total;
        this.success = success;
        this.metaData = metaData == null ? null : ImmutableEdStoreResult.createUnmodifiableMap(true, false, metaData);
        this.message = message;
    }

    private ImmutableEdStoreResult(ImmutableEdStoreResult original, Collection<T> records, @Nullable Long total, @Nullable Boolean success, @Nullable Map<String, Object> metaData, @Nullable String message) {
        this.records = records;
        this.total = total;
        this.success = success;
        this.metaData = metaData;
        this.message = message;
    }

    @Override
    @JsonProperty(value="records")
    public Collection<T> records() {
        return this.records;
    }

    @Override
    @JsonProperty(value="total")
    @Nullable
    public Long total() {
        return this.total;
    }

    @Override
    @JsonProperty(value="success")
    @Nullable
    public Boolean success() {
        return this.success;
    }

    @Override
    @JsonProperty(value="metaData")
    @Nullable
    public Map<String, Object> metaData() {
        return this.metaData;
    }

    @Override
    @JsonProperty(value="message")
    @Nullable
    public String message() {
        return this.message;
    }

    public final ImmutableEdStoreResult<T> withRecords(Collection<T> value) {
        if (this.records == value) {
            return this;
        }
        Collection<T> newValue = Objects.requireNonNull(value, "records");
        return new ImmutableEdStoreResult<T>(this, newValue, this.total, this.success, this.metaData, this.message);
    }

    public final ImmutableEdStoreResult<T> withTotal(@Nullable Long value) {
        if (Objects.equals(this.total, value)) {
            return this;
        }
        return new ImmutableEdStoreResult<T>(this, this.records, value, this.success, this.metaData, this.message);
    }

    public final ImmutableEdStoreResult<T> withSuccess(@Nullable Boolean value) {
        if (Objects.equals(this.success, value)) {
            return this;
        }
        return new ImmutableEdStoreResult<T>(this, this.records, this.total, value, this.metaData, this.message);
    }

    public final ImmutableEdStoreResult<T> withMetaData(@Nullable Map<String, ? extends Object> entries) {
        if (this.metaData == entries) {
            return this;
        }
        Map<String, Object> newValue = entries == null ? null : ImmutableEdStoreResult.createUnmodifiableMap(true, false, entries);
        return new ImmutableEdStoreResult<T>(this, this.records, this.total, this.success, newValue, this.message);
    }

    public final ImmutableEdStoreResult<T> withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableEdStoreResult<T>(this, this.records, this.total, this.success, this.metaData, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEdStoreResult && this.equalTo((ImmutableEdStoreResult)another);
    }

    private boolean equalTo(ImmutableEdStoreResult<T> another) {
        return this.records.equals(another.records) && Objects.equals(this.total, another.total) && Objects.equals(this.success, another.success) && Objects.equals(this.metaData, another.metaData) && Objects.equals(this.message, another.message);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.records.hashCode();
        h = h * 17 + Objects.hashCode(this.total);
        h = h * 17 + Objects.hashCode(this.success);
        h = h * 17 + Objects.hashCode(this.metaData);
        h = h * 17 + Objects.hashCode(this.message);
        return h;
    }

    public String toString() {
        return "EdStoreResult{records=" + this.records + ", total=" + this.total + ", success=" + this.success + ", metaData=" + this.metaData + ", message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T> ImmutableEdStoreResult<T> fromJson(Json<T> json) {
        EdStoreResult.Builder builder = new EdStoreResult.Builder();
        if (json.records != null) {
            builder.records(json.records);
        }
        if (json.total != null) {
            builder.total(json.total);
        }
        if (json.success != null) {
            builder.success(json.success);
        }
        if (json.metaData != null) {
            builder.putAllMetaData(json.metaData);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static <T> ImmutableEdStoreResult<T> of(Collection<T> records, @Nullable Long total, @Nullable Boolean success, @Nullable Map<String, ? extends Object> metaData, @Nullable String message) {
        return new ImmutableEdStoreResult<T>(records, total, success, metaData, message);
    }

    public static <T> ImmutableEdStoreResult<T> copyOf(EdStoreResult<T> instance) {
        if (instance instanceof ImmutableEdStoreResult) {
            return (ImmutableEdStoreResult)instance;
        }
        return new EdStoreResult.Builder<T>().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static class Builder<T> {
        private static final long INIT_BIT_RECORDS = 1L;
        private long initBits = 1L;
        private Collection<T> records;
        private Long total;
        private Boolean success;
        private Map<String, Object> metaData = null;
        private String message;

        Builder() {
            if (!(this instanceof EdStoreResult.Builder)) {
                throw new UnsupportedOperationException("Use: new EdStoreResult.Builder<T>()");
            }
        }

        public final EdStoreResult.Builder<T> from(EdStoreResult<T> instance) {
            String messageValue;
            Map<String, Object> metaDataValue;
            Boolean successValue;
            Objects.requireNonNull(instance, "instance");
            this.records(instance.records());
            Long totalValue = instance.total();
            if (totalValue != null) {
                this.total(totalValue);
            }
            if ((successValue = instance.success()) != null) {
                this.success(successValue);
            }
            if ((metaDataValue = instance.metaData()) != null) {
                this.putAllMetaData(metaDataValue);
            }
            if ((messageValue = instance.message()) != null) {
                this.message(messageValue);
            }
            return (EdStoreResult.Builder)this;
        }

        @JsonProperty(value="records")
        public final EdStoreResult.Builder<T> records(Collection<T> records) {
            this.records = Objects.requireNonNull(records, "records");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (EdStoreResult.Builder)this;
        }

        @JsonProperty(value="total")
        public final EdStoreResult.Builder<T> total(@Nullable Long total) {
            this.total = total;
            return (EdStoreResult.Builder)this;
        }

        @JsonProperty(value="success")
        public final EdStoreResult.Builder<T> success(@Nullable Boolean success) {
            this.success = success;
            return (EdStoreResult.Builder)this;
        }

        public final EdStoreResult.Builder<T> putMetaData(String key, Object value) {
            if (this.metaData == null) {
                this.metaData = new LinkedHashMap<String, Object>();
            }
            this.metaData.put(Objects.requireNonNull(key, "metaData key"), Objects.requireNonNull(value, "metaData value"));
            return (EdStoreResult.Builder)this;
        }

        public final EdStoreResult.Builder<T> putMetaData(Map.Entry<String, ? extends Object> entry) {
            if (this.metaData == null) {
                this.metaData = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.metaData.put(Objects.requireNonNull(k, "metaData key"), Objects.requireNonNull(v, "metaData value"));
            return (EdStoreResult.Builder)this;
        }

        @JsonProperty(value="metaData")
        public final EdStoreResult.Builder<T> metaData(@Nullable Map<String, ? extends Object> metaData) {
            if (metaData == null) {
                this.metaData = null;
                return (EdStoreResult.Builder)this;
            }
            this.metaData = new LinkedHashMap<String, Object>();
            return this.putAllMetaData(metaData);
        }

        public final EdStoreResult.Builder<T> putAllMetaData(Map<String, ? extends Object> metaData) {
            if (this.metaData == null) {
                this.metaData = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : metaData.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.metaData.put(Objects.requireNonNull(k, "metaData key"), Objects.requireNonNull(v, "metaData value"));
            }
            return (EdStoreResult.Builder)this;
        }

        @JsonProperty(value="message")
        public final EdStoreResult.Builder<T> message(@Nullable String message) {
            this.message = message;
            return (EdStoreResult.Builder)this;
        }

        public ImmutableEdStoreResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEdStoreResult(null, this.records, this.total, this.success, this.metaData == null ? null : ImmutableEdStoreResult.createUnmodifiableMap(false, false, this.metaData), this.message);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("records");
            }
            return "Cannot build EdStoreResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json<T>
    extends EdStoreResult<T> {
        Collection<T> records;
        Long total;
        Boolean success;
        Map<String, Object> metaData;
        String message;

        Json() {
        }

        @JsonProperty(value="records")
        public void setRecords(Collection<T> records) {
            this.records = records;
        }

        @JsonProperty(value="total")
        public void setTotal(@Nullable Long total) {
            this.total = total;
        }

        @JsonProperty(value="success")
        public void setSuccess(@Nullable Boolean success) {
            this.success = success;
        }

        @JsonProperty(value="metaData")
        public void setMetaData(@Nullable Map<String, Object> metaData) {
            this.metaData = metaData;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable String message) {
            this.message = message;
        }

        @Override
        public Collection<T> records() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long total() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean success() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> metaData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }
    }
}

