package ch.ralscha.extdirectspring.bean;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link EdFormPostResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEdFormPostResult.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdFormPostResult.of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "EdFormPostResult"})
@Immutable
final class ImmutableEdFormPostResult extends EdFormPostResult {
  private final Map<String, Object> result;

  private ImmutableEdFormPostResult(Map<String, ? extends Object> result) {
    this.result = createUnmodifiableMap(true, false, result);
  }

  private ImmutableEdFormPostResult(ImmutableEdFormPostResult original, Map<String, Object> result) {
    this.result = result;
  }

  /**
   * @return The value of the {@code result} attribute
   */
  @JsonProperty("result")
  @Override
  public Map<String, Object> result() {
    return result;
  }

  /**
   * Copy the current immutable object by replacing the {@link EdFormPostResult#result() result} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the result map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEdFormPostResult withResult(Map<String, ? extends Object> entries) {
    if (this.result == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableEdFormPostResult(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdFormPostResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdFormPostResult
        && equalTo((ImmutableEdFormPostResult) another);
  }

  private boolean equalTo(ImmutableEdFormPostResult another) {
    return result.equals(another.result);
  }

  /**
   * Computes a hash code from attributes: {@code result}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + result.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EdFormPostResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EdFormPostResult{"
        + "result=" + result
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends EdFormPostResult {
    @Nullable Map<String, Object> result = Collections.emptyMap();
    @JsonProperty("result")
    public void setResult(Map<String, Object> result) {
      this.result = result;
    }
    @Override
    public Map<String, Object> result() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEdFormPostResult fromJson(Json json) {
    ImmutableEdFormPostResult.Builder builder = ImmutableEdFormPostResult.builder();
    if (json.result != null) {
      builder.putAllResult(json.result);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code EdFormPostResult} instance.
   * @param result The value for the {@code result} attribute
   * @return An immutable EdFormPostResult instance
   */
  public static ImmutableEdFormPostResult of(Map<String, ? extends Object> result) {
    return new ImmutableEdFormPostResult(result);
  }

  /**
   * Creates an immutable copy of a {@link EdFormPostResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EdFormPostResult instance
   */
  public static ImmutableEdFormPostResult copyOf(EdFormPostResult instance) {
    if (instance instanceof ImmutableEdFormPostResult) {
      return (ImmutableEdFormPostResult) instance;
    }
    return ImmutableEdFormPostResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEdFormPostResult ImmutableEdFormPostResult}.
   * @return A new ImmutableEdFormPostResult builder
   */
  public static ImmutableEdFormPostResult.Builder builder() {
    return new ImmutableEdFormPostResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEdFormPostResult ImmutableEdFormPostResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder 
      extends EdFormPostResult.Builder {
    private Map<String, Object> result = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EdFormPostResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EdFormPostResult instance) {
      Objects.requireNonNull(instance, "instance");
      putAllResult(instance.result());
      return this;
    }

    /**
     * Put one entry to the {@link EdFormPostResult#result() result} map.
     * @param key The key in the result map
     * @param value The associated value in the result map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResult(String key, Object value) {
      this.result.put(
          Objects.requireNonNull(key, "result key"),
          Objects.requireNonNull(value, "result value"));
      return this;
    }

    /**
     * Put one entry to the {@link EdFormPostResult#result() result} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putResult(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.result.put(
          Objects.requireNonNull(k, "result key"),
          Objects.requireNonNull(v, "result value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EdFormPostResult#result() result} map. Nulls are not permitted
     * @param result The entries that will be added to the result map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder result(Map<String, ? extends Object> result) {
      this.result.clear();
      return putAllResult(result);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EdFormPostResult#result() result} map. Nulls are not permitted
     * @param result The entries that will be added to the result map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllResult(Map<String, ? extends Object> result) {
      for (Map.Entry<String, ? extends Object> entry : result.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.result.put(
            Objects.requireNonNull(k, "result key"),
            Objects.requireNonNull(v, "result value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableEdFormPostResult ImmutableEdFormPostResult}.
     * @return An immutable instance of EdFormPostResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdFormPostResult build() {
      return new ImmutableEdFormPostResult(null, createUnmodifiableMap(false, false, result));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
