package ch.ralscha.extdirectspring.bean;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link EdStoreResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new EdStoreResult.Builder<T>()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdStoreResult.<T>of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "EdStoreResult<T>"})
@Immutable
final class ImmutableEdStoreResult<T> extends EdStoreResult<T> {
  private final Collection<T> records;
  private final @Nullable Long total;
  private final @Nullable Boolean success;
  private final @Nullable Map<String, Object> metaData;
  private final @Nullable String message;

  private ImmutableEdStoreResult(
      Collection<T> records,
      @Nullable Long total,
      @Nullable Boolean success,
      @Nullable Map<String, ? extends Object> metaData,
      @Nullable String message) {
    this.records = Objects.requireNonNull(records, "records");
    this.total = total;
    this.success = success;
    this.metaData = metaData == null ? null : createUnmodifiableMap(true, false, metaData);
    this.message = message;
  }

  private ImmutableEdStoreResult(
      ImmutableEdStoreResult original,
      Collection<T> records,
      @Nullable Long total,
      @Nullable Boolean success,
      @Nullable Map<String, Object> metaData,
      @Nullable String message) {
    this.records = records;
    this.total = total;
    this.success = success;
    this.metaData = metaData;
    this.message = message;
  }

  /**
   * @return The value of the {@code records} attribute
   */
  @JsonProperty("records")
  @Override
  public Collection<T> records() {
    return records;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty("total")
  @Override
  public @Nullable Long total() {
    return total;
  }

  /**
   * @return The value of the {@code success} attribute
   */
  @JsonProperty("success")
  @Override
  public @Nullable Boolean success() {
    return success;
  }

  /**
   * @return The value of the {@code metaData} attribute
   */
  @JsonProperty("metaData")
  @Override
  public @Nullable Map<String, Object> metaData() {
    return metaData;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdStoreResult#records() records} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for records
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdStoreResult<T> withRecords(Collection<T> value) {
    if (this.records == value) return this;
    Collection<T> newValue = Objects.requireNonNull(value, "records");
    return new ImmutableEdStoreResult<T>(this, newValue, this.total, this.success, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdStoreResult#total() total} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for total (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdStoreResult<T> withTotal(@Nullable Long value) {
    if (Objects.equals(this.total, value)) return this;
    return new ImmutableEdStoreResult<T>(this, this.records, value, this.success, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdStoreResult#success() success} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for success (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdStoreResult<T> withSuccess(@Nullable Boolean value) {
    if (Objects.equals(this.success, value)) return this;
    return new ImmutableEdStoreResult<T>(this, this.records, this.total, value, this.metaData, this.message);
  }

  /**
   * Copy the current immutable object by replacing the {@link EdStoreResult#metaData() metaData} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the metaData map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEdStoreResult<T> withMetaData(@Nullable Map<String, ? extends Object> entries) {
    if (this.metaData == entries) return this;
    @Nullable Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(true, false, entries);
    return new ImmutableEdStoreResult<T>(this, this.records, this.total, this.success, newValue, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdStoreResult#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdStoreResult<T> withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableEdStoreResult<T>(this, this.records, this.total, this.success, this.metaData, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdStoreResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @SuppressWarnings("unchecked")
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdStoreResult<?>
        && equalTo((ImmutableEdStoreResult<T>) another);
  }

  private boolean equalTo(ImmutableEdStoreResult<T> another) {
    return records.equals(another.records)
        && Objects.equals(total, another.total)
        && Objects.equals(success, another.success)
        && Objects.equals(metaData, another.metaData)
        && Objects.equals(message, another.message);
  }

  /**
   * Computes a hash code from attributes: {@code records}, {@code total}, {@code success}, {@code metaData}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + records.hashCode();
    h += (h << 5) + Objects.hashCode(total);
    h += (h << 5) + Objects.hashCode(success);
    h += (h << 5) + Objects.hashCode(metaData);
    h += (h << 5) + Objects.hashCode(message);
    return h;
  }

  /**
   * Prints the immutable value {@code EdStoreResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EdStoreResult{"
        + "records=" + records
        + ", total=" + total
        + ", success=" + success
        + ", metaData=" + metaData
        + ", message=" + message
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T> extends EdStoreResult<T> {
    @Nullable Collection<T> records;
    @Nullable Long total;
    @Nullable Boolean success;
    @Nullable Map<String, Object> metaData = null;
    @Nullable String message;
    @JsonProperty("records")
    public void setRecords(Collection<T> records) {
      this.records = records;
    }
    @JsonProperty("total")
    public void setTotal(@Nullable Long total) {
      this.total = total;
    }
    @JsonProperty("success")
    public void setSuccess(@Nullable Boolean success) {
      this.success = success;
    }
    @JsonProperty("metaData")
    public void setMetaData(@Nullable Map<String, Object> metaData) {
      this.metaData = metaData;
    }
    @JsonProperty("message")
    public void setMessage(@Nullable String message) {
      this.message = message;
    }
    @Override
    public Collection<T> records() { throw new UnsupportedOperationException(); }
    @Override
    public Long total() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean success() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> metaData() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <T> ImmutableEdStoreResult<T> fromJson(Json<T> json) {
    EdStoreResult.Builder<T> builder = new EdStoreResult.Builder<T>();
    if (json.records != null) {
      builder.records(json.records);
    }
    if (json.total != null) {
      builder.total(json.total);
    }
    if (json.success != null) {
      builder.success(json.success);
    }
    if (json.metaData != null) {
      builder.putAllMetaData(json.metaData);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    return (ImmutableEdStoreResult<T>) builder.build();
  }

  /**
   * Construct a new immutable {@code EdStoreResult} instance.
   * @param records The value for the {@code records} attribute
   * @param total The value for the {@code total} attribute
   * @param success The value for the {@code success} attribute
   * @param metaData The value for the {@code metaData} attribute
   * @param message The value for the {@code message} attribute
   * @return An immutable EdStoreResult instance
   */
  public static <T> ImmutableEdStoreResult<T> of(Collection<T> records, @Nullable Long total, @Nullable Boolean success, @Nullable Map<String, ? extends Object> metaData, @Nullable String message) {
    return new ImmutableEdStoreResult<T>(records, total, success, metaData, message);
  }

  /**
   * Creates an immutable copy of a {@link EdStoreResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable EdStoreResult instance
   */
  public static <T> ImmutableEdStoreResult<T> copyOf(EdStoreResult<T> instance) {
    if (instance instanceof ImmutableEdStoreResult<?>) {
      return (ImmutableEdStoreResult<T>) instance;
    }
    return new EdStoreResult.Builder<T>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableEdStoreResult ImmutableEdStoreResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static class Builder<T> {
    private static final long INIT_BIT_RECORDS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Collection<T> records;
    private @Nullable Long total;
    private @Nullable Boolean success;
    private Map<String, Object> metaData = null;
    private @Nullable String message;

    /**
     * Creates a builder for {@link ImmutableEdStoreResult ImmutableEdStoreResult} instances.
     */
    public Builder() {
      if (!(this instanceof EdStoreResult.Builder<?>)) {
        throw new UnsupportedOperationException("Use: new EdStoreResult.Builder<T>()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code EdStoreResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final EdStoreResult.Builder<T> from(EdStoreResult<T> instance) {
      Objects.requireNonNull(instance, "instance");
      records(instance.records());
      @Nullable Long totalValue = instance.total();
      if (totalValue != null) {
        total(totalValue);
      }
      @Nullable Boolean successValue = instance.success();
      if (successValue != null) {
        success(successValue);
      }
      @Nullable Map<String, Object> metaDataValue = instance.metaData();
      if (metaDataValue != null) {
        putAllMetaData(metaDataValue);
      }
      @Nullable String messageValue = instance.message();
      if (messageValue != null) {
        message(messageValue);
      }
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link EdStoreResult#records() records} attribute.
     * @param records The value for records 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("records")
    public final EdStoreResult.Builder<T> records(Collection<T> records) {
      this.records = Objects.requireNonNull(records, "records");
      initBits &= ~INIT_BIT_RECORDS;
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link EdStoreResult#total() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total")
    public final EdStoreResult.Builder<T> total(@Nullable Long total) {
      this.total = total;
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link EdStoreResult#success() success} attribute.
     * @param success The value for success (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("success")
    public final EdStoreResult.Builder<T> success(@Nullable Boolean success) {
      this.success = success;
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Put one entry to the {@link EdStoreResult#metaData() metaData} map.
     * @param key The key in the metaData map
     * @param value The associated value in the metaData map
     * @return {@code this} builder for use in a chained invocation
     */
    public final EdStoreResult.Builder<T> putMetaData(String key, Object value) {
      if (this.metaData == null) {
        this.metaData = new LinkedHashMap<String, Object>();
      }
      this.metaData.put(
          Objects.requireNonNull(key, "metaData key"),
          Objects.requireNonNull(value, "metaData value"));
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Put one entry to the {@link EdStoreResult#metaData() metaData} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final EdStoreResult.Builder<T> putMetaData(Map.Entry<String, ? extends Object> entry) {
      if (this.metaData == null) {
        this.metaData = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.metaData.put(
          Objects.requireNonNull(k, "metaData key"),
          Objects.requireNonNull(v, "metaData value"));
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EdStoreResult#metaData() metaData} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param metaData The entries that will be added to the metaData map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metaData")
    public final EdStoreResult.Builder<T> metaData(@Nullable Map<String, ? extends Object> metaData) {
      if (metaData == null) {
        this.metaData = null;
        return (EdStoreResult.Builder<T>) this;
      }
      this.metaData = new LinkedHashMap<String, Object>();
      return putAllMetaData(metaData);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EdStoreResult#metaData() metaData} map. Nulls are not permitted
     * @param metaData The entries that will be added to the metaData map
     * @return {@code this} builder for use in a chained invocation
     */
    public final EdStoreResult.Builder<T> putAllMetaData(Map<String, ? extends Object> metaData) {
      if (this.metaData == null) {
        this.metaData = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : metaData.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.metaData.put(
            Objects.requireNonNull(k, "metaData key"),
            Objects.requireNonNull(v, "metaData value"));
      }
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Initializes the value for the {@link EdStoreResult#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final EdStoreResult.Builder<T> message(@Nullable String message) {
      this.message = message;
      return (EdStoreResult.Builder<T>) this;
    }

    /**
     * Builds a new {@link ImmutableEdStoreResult ImmutableEdStoreResult}.
     * @return An immutable instance of EdStoreResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdStoreResult<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEdStoreResult<T>(
          null,
          records,
          total,
          success,
          metaData == null ? null : createUnmodifiableMap(false, false, metaData),
          message);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_RECORDS) != 0) attributes.add("records");
      return "Cannot build EdStoreResult, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
