/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.ImmutableEdFormPostResult;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.immutables.value.Value;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

@JsonSerialize(as=ImmutableEdFormPostResult.class)
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
@Value.Immutable
public abstract class EdFormPostResult {
    private static final String ERRORS_PROPERTY = "errors";
    private static final String SUCCESS_PROPERTY = "success";

    @Value.Parameter
    public abstract Map<String, Object> result();

    public static EdFormPostResult success() {
        return ImmutableEdFormPostResult.builder().putResult(SUCCESS_PROPERTY, Boolean.TRUE).build();
    }

    public static EdFormPostResult success(Map<String, Object> result) {
        return ((ImmutableEdFormPostResult.Builder)ImmutableEdFormPostResult.builder().result(result)).putResult(SUCCESS_PROPERTY, Boolean.TRUE).build();
    }

    public static EdFormPostResult create(BindingResult bindingResult) {
        return ImmutableEdFormPostResult.builder().addErrors(null, null, bindingResult).build();
    }

    public static EdFormPostResult create(BindingResult bindingResult, boolean success) {
        return ImmutableEdFormPostResult.builder().addErrors(null, null, bindingResult).putResult(SUCCESS_PROPERTY, success).build();
    }

    public static EdFormPostResult create(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        return ImmutableEdFormPostResult.builder().addErrors(locale, messageSource, bindingResult).build();
    }

    public static EdFormPostResult create(Locale locale, MessageSource messageSource, BindingResult bindingResult, boolean success) {
        ImmutableEdFormPostResult.Builder builder = ImmutableEdFormPostResult.builder();
        builder.addErrors(locale, messageSource, bindingResult);
        return builder.putResult(SUCCESS_PROPERTY, success).build();
    }

    public static Builder builder() {
        return ImmutableEdFormPostResult.builder();
    }

    public static abstract class Builder {
        private final Map<String, List<String>> helper = new LinkedHashMap<String, List<String>>();

        public abstract Builder result(Map<String, ? extends Object> var1);

        public abstract Builder putResult(String var1, Object var2);

        public abstract EdFormPostResult build();

        public Builder addErrors(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
            if (bindingResult != null && bindingResult.hasFieldErrors()) {
                HashMap<String, ArrayList<String>> errorMap = new HashMap<String, ArrayList<String>>();
                for (FieldError fieldError : bindingResult.getFieldErrors()) {
                    ArrayList<String> fieldErrors;
                    String message = fieldError.getDefaultMessage();
                    if (messageSource != null) {
                        Locale loc = locale != null ? locale : Locale.getDefault();
                        message = messageSource.getMessage(fieldError.getCode(), fieldError.getArguments(), loc);
                    }
                    if ((fieldErrors = (ArrayList<String>)errorMap.get(fieldError.getField())) == null) {
                        fieldErrors = new ArrayList<String>();
                        errorMap.put(fieldError.getField(), fieldErrors);
                    }
                    fieldErrors.add(message);
                }
                if (errorMap.isEmpty()) {
                    this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.TRUE);
                } else {
                    this.putResult(EdFormPostResult.ERRORS_PROPERTY, errorMap);
                    this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.FALSE);
                }
            } else {
                this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.TRUE);
            }
            return this;
        }

        public Builder addErrorsResolveCode(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
            if (bindingResult != null && bindingResult.hasFieldErrors()) {
                HashMap<String, ArrayList<String>> errorMap = new HashMap<String, ArrayList<String>>();
                for (FieldError fieldError : bindingResult.getFieldErrors()) {
                    ArrayList<String> fieldErrors;
                    String message = fieldError.getDefaultMessage();
                    if (messageSource != null) {
                        Locale loc = locale != null ? locale : Locale.getDefault();
                        for (String code : fieldError.getCodes()) {
                            try {
                                message = messageSource.getMessage(code, fieldError.getArguments(), loc);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (message != null && !message.equals(code)) break;
                        }
                    }
                    if ((fieldErrors = (ArrayList<String>)errorMap.get(fieldError.getField())) == null) {
                        fieldErrors = new ArrayList<String>();
                        errorMap.put(fieldError.getField(), fieldErrors);
                    }
                    fieldErrors.add(message);
                }
                if (errorMap.isEmpty()) {
                    this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.TRUE);
                } else {
                    this.putResult(EdFormPostResult.ERRORS_PROPERTY, errorMap);
                    this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.FALSE);
                }
            } else {
                this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.TRUE);
            }
            return this;
        }

        public Builder addError(BindingResult bindingResult) {
            this.addErrors(null, null, bindingResult);
            return this;
        }

        public Builder fail() {
            this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.FALSE);
            return this;
        }

        public Builder success() {
            this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.TRUE);
            return this;
        }

        public Builder addError(String field, String error) {
            Assert.notNull((Object)field, (String)"field must not be null");
            Assert.notNull((Object)error, (String)"field must not be null");
            return this.addErrors(field, Collections.singletonList(error));
        }

        public Builder addErrors(String field, List<String> errors) {
            Assert.notNull((Object)field, (String)"field must not be null");
            Assert.notNull(errors, (String)"field must not be null");
            List<String> fieldErrors = this.helper.get(field);
            if (fieldErrors == null) {
                fieldErrors = new ArrayList<String>();
                this.helper.put(field, fieldErrors);
            }
            fieldErrors.addAll(errors);
            this.putResult(EdFormPostResult.ERRORS_PROPERTY, this.helper);
            this.putResult(EdFormPostResult.SUCCESS_PROPERTY, Boolean.FALSE);
            return this;
        }
    }
}

