/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.bean.api.RemotingApi;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;

public final class ExtDirectSpringUtil {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static Class<?> javaUtilOptionalClass = null;
    private static final long secondsInAMonth = 2592000L;

    private ExtDirectSpringUtil() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public static Object invoke(ApplicationContext context, String beanName, MethodInfo methodInfo, Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object bean = context.getBean(beanName);
        Method handlerMethod = methodInfo.getMethod();
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        Object result = handlerMethod.invoke(bean, params);
        if (result != null && result.getClass().equals(javaUtilOptionalClass)) {
            return OptionalUnwrapper.unwrap(result);
        }
        return result;
    }

    public static Object invoke(HttpServletRequest request, HttpServletResponse response, Locale locale, ApplicationContext context, ExtDirectRequest directRequest, ParametersResolver parametersResolver, MethodInfoCache cache) throws Exception {
        MethodInfo methodInfo = cache.get(directRequest.getAction(), directRequest.getMethod());
        Object[] resolvedParams = parametersResolver.resolveParameters(request, response, locale, directRequest, methodInfo);
        return ExtDirectSpringUtil.invoke(context, directRequest.getAction(), methodInfo, resolvedParams);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static void addCacheHeaders(HttpServletResponse response, String etag, Integer month) {
        Assert.notNull((Object)etag, (String)"ETag must not be null");
        long seconds = month != null ? (long)month.intValue() * 2592000L : 15552000L;
        response.setDateHeader("Expires", System.currentTimeMillis() + seconds * 1000L);
        response.setHeader("ETag", etag);
        response.setHeader("Cache-Control", "public, max-age=" + seconds);
    }

    public static void handleCacheableResponse(HttpServletRequest request, HttpServletResponse response, byte[] data, String contentType) throws IOException {
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = "\"0" + DigestUtils.md5DigestAsHex((byte[])data) + "\"";
        ExtDirectSpringUtil.addCacheHeaders(response, etag, 6);
        if (etag.equals(ifNoneMatch)) {
            response.setStatus(304);
            return;
        }
        response.setContentType(contentType);
        response.setContentLength(data.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }

    public static String generateApiString(ApplicationContext ctx) throws JsonProcessingException {
        return ExtDirectSpringUtil.generateApiString(ctx, "REMOTING_API", "POLLING_URLS");
    }

    public static String generateApiString(ApplicationContext ctx, String remotingVarName, String pollingApiVarName) throws JsonProcessingException {
        RemotingApi remotingApi = new RemotingApi(((ConfigurationService)ctx.getBean(ConfigurationService.class)).getConfiguration().getProviderType(), "router", null);
        for (Map.Entry<MethodInfoCache.Key, MethodInfo> entry : (MethodInfoCache)ctx.getBean(MethodInfoCache.class)) {
            MethodInfo methodInfo = entry.getValue();
            if (methodInfo.getAction() != null) {
                remotingApi.addAction(entry.getKey().getBeanName(), methodInfo.getAction());
                continue;
            }
            if (methodInfo.getPollingProvider() == null) continue;
            remotingApi.addPollingProvider(methodInfo.getPollingProvider());
        }
        remotingApi.sort();
        StringBuilder extDirectConfig = new StringBuilder(100);
        extDirectConfig.append("var ").append(remotingVarName).append(" = ");
        extDirectConfig.append(new ObjectMapper().writer().withDefaultPrettyPrinter().writeValueAsString((Object)remotingApi));
        extDirectConfig.append(";");
        List<PollingProvider> pollingProviders = remotingApi.getPollingProviders();
        if (!pollingProviders.isEmpty()) {
            extDirectConfig.append("\n\nvar ").append(pollingApiVarName).append(" = {\n");
            for (int i = 0; i < pollingProviders.size(); ++i) {
                extDirectConfig.append("  \"");
                extDirectConfig.append(pollingProviders.get(i).getEvent());
                extDirectConfig.append("\" : \"poll/");
                extDirectConfig.append(pollingProviders.get(i).getBeanName());
                extDirectConfig.append("/");
                extDirectConfig.append(pollingProviders.get(i).getMethod());
                extDirectConfig.append("/");
                extDirectConfig.append(pollingProviders.get(i).getEvent());
                extDirectConfig.append("\"");
                if (i >= pollingProviders.size() - 1) continue;
                extDirectConfig.append(",\n");
            }
            extDirectConfig.append("\n};");
        }
        return extDirectConfig.toString();
    }

    static {
        try {
            javaUtilOptionalClass = ClassUtils.forName((String)"java.util.Optional", (ClassLoader)RouterController.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @UsesJava8
    private static class OptionalUnwrapper {
        private OptionalUnwrapper() {
        }

        public static Object unwrap(Object optionalObject) {
            return ((Optional)optionalObject).orElse(null);
        }
    }
}

