/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.ImmutableEdStoreResult;
import ch.ralscha.extdirectspring.bean.JsonViewHint;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize(as=ImmutableEdStoreResult.class)
@JsonDeserialize(as=ImmutableEdStoreResult.class)
@JsonPropertyOrder(value={"metaData", "success", "total", "records", "message"})
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
@Value.Immutable
public abstract class EdStoreResult<T>
extends JsonViewHint {
    @Value.Parameter
    public abstract Collection<T> records();

    @Nullable
    @Value.Parameter
    public abstract Long total();

    @Nullable
    @Value.Parameter
    public abstract Boolean success();

    @Nullable
    @Value.Parameter
    public abstract Map<String, Object> metaData();

    @Nullable
    @Value.Parameter
    public abstract String message();

    public static <T> EdStoreResult<T> success(T record) {
        return ImmutableEdStoreResult.of(Collections.singletonList(record), null, Boolean.TRUE, null, null);
    }

    public static <T> EdStoreResult<T> success(T[] records) {
        return ImmutableEdStoreResult.of(Arrays.asList(records), null, Boolean.TRUE, null, null);
    }

    public static <T> EdStoreResult<T> success(Collection<T> records) {
        return ImmutableEdStoreResult.of(records, null, Boolean.TRUE, null, null);
    }

    public static <T> EdStoreResult<T> success(Collection<T> records, Long total) {
        return ImmutableEdStoreResult.of(records, total, Boolean.TRUE, null, null);
    }

    public static <T> EdStoreResult<T> success(Collection<T> records, Class<?> jsonView) {
        ImmutableEdStoreResult<T> result = ImmutableEdStoreResult.of(records, null, Boolean.TRUE, null, null);
        result.setJsonView(jsonView);
        return result;
    }

    public static <T> EdStoreResult<T> success(Collection<T> records, Long total, Class<?> jsonView) {
        ImmutableEdStoreResult<T> result = ImmutableEdStoreResult.of(records, total, Boolean.TRUE, null, null);
        result.setJsonView(jsonView);
        return result;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T>
    extends ImmutableEdStoreResult.Builder<T> {
    }
}

