/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.util.JsonHandler;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Configuration {
    private String defaultExceptionMessage = "Server Error";
    private boolean sendExceptionMessage = false;
    private boolean sendStacktrace = false;
    private Map<Class<?>, String> exceptionToMessage;
    private boolean alwaysWrapStoreResponse = false;
    private boolean synchronizeOnSession = false;
    private String apiNs = "Ext.app";
    private String actionNs = null;
    private String remotingApiVar = "REMOTING_API";
    private String pollingUrlsVar = "POLLING_URLS";
    private boolean fullRouterUrl = false;
    private String baseRouterUrl = null;
    private Integer timeout = null;
    private Integer maxRetries = null;
    private Object enableBuffer = null;
    private Integer bufferLimit = null;
    private boolean streamResponse = false;
    private String jsContentType = "application/javascript";
    private BatchedMethodsExecutionPolicy batchedMethodsExecutionPolicy = BatchedMethodsExecutionPolicy.SEQUENTIAL;
    private ExecutorService batchedMethodsExecutorService = null;
    private String providerType = "remoting";
    private String frameDomain = null;
    private String frameDomainScript = "<script type=\"text/javascript\">document.domain = '%s';</script>";
    private JsonHandler jsonHandler;
    private ConversionService conversionService;

    public String getDefaultExceptionMessage() {
        return this.defaultExceptionMessage;
    }

    public void setDefaultExceptionMessage(String defaultExceptionMessage) {
        this.defaultExceptionMessage = defaultExceptionMessage;
    }

    public boolean isSendExceptionMessage() {
        return this.sendExceptionMessage;
    }

    public void setSendExceptionMessage(boolean sendExceptionMessage) {
        this.sendExceptionMessage = sendExceptionMessage;
    }

    public boolean isSendStacktrace() {
        return this.sendStacktrace;
    }

    public void setSendStacktrace(boolean sendStacktrace) {
        this.sendStacktrace = sendStacktrace;
    }

    public Map<Class<?>, String> getExceptionToMessage() {
        return this.exceptionToMessage;
    }

    public void setExceptionToMessage(Map<Class<?>, String> exceptionToMessage) {
        this.exceptionToMessage = exceptionToMessage;
    }

    public boolean isAlwaysWrapStoreResponse() {
        return this.alwaysWrapStoreResponse;
    }

    public void setAlwaysWrapStoreResponse(boolean alwaysWrapStoreResponse) {
        this.alwaysWrapStoreResponse = alwaysWrapStoreResponse;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Object getEnableBuffer() {
        return this.enableBuffer;
    }

    public void setEnableBuffer(Object enableBuffer) {
        this.enableBuffer = enableBuffer;
    }

    public Integer getBufferLimit() {
        return this.bufferLimit;
    }

    public void setBufferLimit(Integer bufferLimit) {
        this.bufferLimit = bufferLimit;
    }

    public String getMessage(Throwable exception) {
        if (this.getExceptionToMessage() != null) {
            String message = this.getExceptionToMessage().get(exception.getClass());
            if (StringUtils.hasText((String)message)) {
                return message;
            }
            if (this.getExceptionToMessage().containsKey(exception.getClass())) {
                return exception.getMessage();
            }
        }
        if (this.isSendExceptionMessage()) {
            return exception.getMessage();
        }
        return this.getDefaultExceptionMessage();
    }

    public boolean isStreamResponse() {
        return this.streamResponse;
    }

    public void setStreamResponse(boolean streamResponse) {
        this.streamResponse = streamResponse;
    }

    public void setJsContentType(String jsContentType) {
        this.jsContentType = jsContentType;
    }

    public String getJsContentType() {
        return this.jsContentType;
    }

    public BatchedMethodsExecutionPolicy getBatchedMethodsExecutionPolicy() {
        return this.batchedMethodsExecutionPolicy;
    }

    public void setBatchedMethodsExecutionPolicy(BatchedMethodsExecutionPolicy batchedMethodsExecutionPolicy) {
        Assert.notNull((Object)((Object)batchedMethodsExecutionPolicy), (String)"batchedMethodsExecutionPolicy must not be null");
        this.batchedMethodsExecutionPolicy = batchedMethodsExecutionPolicy;
    }

    public ExecutorService getBatchedMethodsExecutorService() {
        return this.batchedMethodsExecutorService;
    }

    public void setBatchedMethodsExecutorService(ExecutorService batchedMethodsExecutorService) {
        this.batchedMethodsExecutorService = batchedMethodsExecutorService;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getFrameDomain() {
        return this.frameDomain;
    }

    public void setFrameDomain(String frameDomain) {
        this.frameDomain = frameDomain;
    }

    public String getFrameDomainScript() {
        return this.frameDomainScript;
    }

    public void setFrameDomainScript(String frameDomainScript) {
        this.frameDomainScript = frameDomainScript;
    }

    public String getApiNs() {
        return this.apiNs;
    }

    public void setApiNs(String apiNs) {
        this.apiNs = apiNs;
    }

    public String getActionNs() {
        return this.actionNs;
    }

    public void setActionNs(String actionNs) {
        this.actionNs = actionNs;
    }

    public String getRemotingApiVar() {
        return this.remotingApiVar;
    }

    public void setRemotingApiVar(String remotingApiVar) {
        this.remotingApiVar = remotingApiVar;
    }

    public String getPollingUrlsVar() {
        return this.pollingUrlsVar;
    }

    public void setPollingUrlsVar(String pollingUrlsVar) {
        this.pollingUrlsVar = pollingUrlsVar;
    }

    public boolean isFullRouterUrl() {
        return this.fullRouterUrl;
    }

    public void setFullRouterUrl(boolean fullRouterUrl) {
        this.fullRouterUrl = fullRouterUrl;
    }

    public String getBaseRouterUrl() {
        return this.baseRouterUrl;
    }

    public void setBaseRouterUrl(String baseRouterUrl) {
        this.baseRouterUrl = baseRouterUrl;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public void setJsonHandler(JsonHandler jsonHandler) {
        this.jsonHandler = jsonHandler;
    }

    public String postProcessRequestUrl(HttpServletRequest request, String requestUrlString) {
        return requestUrlString;
    }
}

