/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.EdFormLoadResult;
import ch.ralscha.extdirectspring.bean.EdFormPostResult;
import ch.ralscha.extdirectspring.bean.EdStoreResult;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectFormPostResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectResponseRaw;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResult;
import ch.ralscha.extdirectspring.bean.JsonViewHint;
import ch.ralscha.extdirectspring.bean.ModelAndJsonView;
import ch.ralscha.extdirectspring.controller.BatchedMethodsExecutionPolicy;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.ExtRequestListener;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.util.WebUtils;

@Controller
public class RouterController {
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json", ExtDirectSpringUtil.UTF8_CHARSET);
    public static final MediaType TEXT_HTML = new MediaType("text", "html", ExtDirectSpringUtil.UTF8_CHARSET);
    private static final Log log = LogFactory.getLog(RouterController.class);
    private final RequestMappingHandlerAdapter handlerAdapter;
    private final ConfigurationService configurationService;
    private final MethodInfoCache methodInfoCache;
    @Autowired(required=false)
    private Set<ExtRequestListener> extRequestListeners;

    @Autowired
    public RouterController(RequestMappingHandlerAdapter handlerAdapter, ConfigurationService configurationService, MethodInfoCache methodInfoCache) {
        this.handlerAdapter = handlerAdapter;
        this.configurationService = configurationService;
        this.methodInfoCache = methodInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    public void poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        boolean streamResponse;
        Class<?> jsonView;
        ExtDirectPollResponse directPollResponse;
        block14: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            MethodInfo methodInfo = this.methodInfoCache.get(beanName, method);
            jsonView = null;
            if (methodInfo != null) {
                streamResponse = this.configurationService.getConfiguration().isStreamResponse() || methodInfo.isStreamResponse();
                try {
                    Object[] parameters = this.configurationService.getParametersResolver().prepareParameters(request, response, locale, methodInfo);
                    if (this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                Object result = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                                if (result instanceof ModelAndJsonView) {
                                    ModelAndJsonView modelAndJsonView = (ModelAndJsonView)result;
                                    directPollResponse.setData(modelAndJsonView.getModel());
                                    jsonView = RouterController.getJsonView(modelAndJsonView, methodInfo.getJsonView());
                                } else {
                                    directPollResponse.setData(result);
                                    jsonView = RouterController.getJsonView(result, methodInfo.getJsonView());
                                }
                                break block14;
                            }
                        }
                        Object result = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                        if (result instanceof ModelAndJsonView) {
                            ModelAndJsonView modelAndJsonView = (ModelAndJsonView)result;
                            directPollResponse.setData(modelAndJsonView.getModel());
                            jsonView = RouterController.getJsonView(modelAndJsonView, methodInfo.getJsonView());
                        } else {
                            directPollResponse.setData(result);
                            jsonView = RouterController.getJsonView(result, methodInfo.getJsonView());
                        }
                        break block14;
                    }
                    Object result = ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), beanName, methodInfo, parameters);
                    if (result instanceof ModelAndJsonView) {
                        ModelAndJsonView modelAndJsonView = (ModelAndJsonView)result;
                        directPollResponse.setData(modelAndJsonView.getModel());
                        jsonView = RouterController.getJsonView(modelAndJsonView, methodInfo.getJsonView());
                        break block14;
                    }
                    directPollResponse.setData(result);
                    jsonView = RouterController.getJsonView(result, methodInfo.getJsonView());
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    directPollResponse.setData(this.handleException(methodInfo, directPollResponse, e, request));
                }
            } else {
                log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directPollResponse, beanName, method);
                streamResponse = this.configurationService.getConfiguration().isStreamResponse();
            }
        }
        this.writeJsonResponse(response, directPollResponse, jsonView, streamResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) throws IOException {
        boolean streamResponse;
        ExtDirectResponse directResponse = new ExtDirectResponse(request);
        MethodInfo methodInfo = this.methodInfoCache.get(extAction, extMethod);
        if (methodInfo != null && methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        if (methodInfo != null && methodInfo.getHandlerMethod() != null) {
            streamResponse = this.configurationService.getConfiguration().isStreamResponse() || methodInfo.isStreamResponse();
            HandlerMethod handlerMethod = methodInfo.getHandlerMethod();
            try {
                Object formPostResult;
                ModelAndView modelAndView;
                if (this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        Object mutex;
                        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                        synchronized (object) {
                            modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                        }
                    } else {
                        modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                    }
                } else {
                    modelAndView = this.handlerAdapter.handle(request, response, (Object)handlerMethod);
                }
                Map model = modelAndView.getModel();
                if (model.containsKey("extDirectFormPostResult")) {
                    formPostResult = (ExtDirectFormPostResult)model.get("extDirectFormPostResult");
                    directResponse.setResult(((ExtDirectFormPostResult)formPostResult).getResult());
                    directResponse.setJsonView(RouterController.getJsonView(formPostResult, methodInfo.getJsonView()));
                } else if (model.containsKey("edFormPostResult")) {
                    formPostResult = (EdFormPostResult)model.get("edFormPostResult");
                    directResponse.setResult(((EdFormPostResult)formPostResult).result());
                    directResponse.setJsonView(RouterController.getJsonView(formPostResult, methodInfo.getJsonView()));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + extMethod), e.getCause() != null ? e.getCause() : e);
                directResponse.setResult(this.handleException(methodInfo, directResponse, e, request));
            }
        } else {
            streamResponse = this.configurationService.getConfiguration().isStreamResponse();
            log.error((Object)("Error invoking method '" + extAction + "." + extMethod + "'. Method  or Bean not found"));
            this.handleMethodNotFoundError(directResponse, extAction, extMethod);
        }
        this.writeJsonResponse(response, directResponse, null, streamResponse, ExtDirectSpringUtil.isMultipart(request));
        return null;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    public void router(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Object requestData = this.configurationService.getJsonHandler().readValue((InputStream)request.getInputStream(), Object.class);
        List<Object> directRequests = null;
        if (requestData instanceof Map) {
            directRequests = Collections.singletonList(this.configurationService.getJsonHandler().convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            directRequests = new ArrayList();
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.configurationService.getJsonHandler().convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        if (directRequests != null) {
            if (directRequests.size() == 1) {
                this.handleMethodCallOne((ExtDirectRequest)directRequests.get(0), request, response, locale);
            } else if (this.configurationService.getConfiguration().getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.SEQUENTIAL) {
                this.handleMethodCallsSequential(directRequests, request, response, locale);
            } else if (this.configurationService.getConfiguration().getBatchedMethodsExecutionPolicy() == BatchedMethodsExecutionPolicy.CONCURRENT) {
                this.handleMethodCallsConcurrent(directRequests, request, response, locale);
            }
        }
    }

    private void handleMethodCallsConcurrent(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        ArrayList<Future<ExtDirectResponse>> futures = new ArrayList<Future<ExtDirectResponse>>(directRequests.size());
        for (ExtDirectRequest directRequest : directRequests) {
            Callable<ExtDirectResponse> callable = this.createMethodCallCallable(directRequest, request, response, locale);
            futures.add(this.configurationService.getConfiguration().getBatchedMethodsExecutorService().submit(callable));
        }
        ObjectMapper objectMapper = this.configurationService.getJsonHandler().getMapper();
        ArrayList<BaseResponse> directResponses = new ArrayList<BaseResponse>(directRequests.size());
        boolean streamResponse = this.configurationService.getConfiguration().isStreamResponse();
        for (Future future : futures) {
            try {
                ExtDirectResponse directResponse = (ExtDirectResponse)future.get();
                streamResponse = streamResponse || directResponse.isStreamResponse();
                Class<?> jsonView = directResponse.getJsonView();
                if (jsonView == null) {
                    directResponses.add(directResponse);
                    continue;
                }
                String jsonResult = objectMapper.writerWithView(jsonView).writeValueAsString(directResponse.getResult());
                directResponses.add(new ExtDirectResponseRaw(directResponse, jsonResult));
            }
            catch (InterruptedException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error((Object)"Error invoking method", (Throwable)e);
            }
        }
        this.writeJsonResponse(response, directResponses, null, streamResponse);
    }

    private Callable<ExtDirectResponse> createMethodCallCallable(final ExtDirectRequest directRequest, final HttpServletRequest request, final HttpServletResponse response, final Locale locale) {
        return new Callable<ExtDirectResponse>(){

            @Override
            public ExtDirectResponse call() throws Exception {
                return RouterController.this.handleMethodCall(directRequest, request, response, locale);
            }
        };
    }

    private void handleMethodCallOne(ExtDirectRequest directRequest, HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Set<BaseResponse> responseObject;
        ExtDirectResponse directResponse = this.handleMethodCall(directRequest, request, response, locale);
        boolean streamResponse = this.configurationService.getConfiguration().isStreamResponse() || directResponse.isStreamResponse();
        Class<?> jsonView = directResponse.getJsonView();
        if (jsonView == null) {
            responseObject = Collections.singleton(directResponse);
        } else {
            ObjectMapper objectMapper = this.configurationService.getJsonHandler().getMapper();
            String jsonResult = objectMapper.writerWithView(jsonView).writeValueAsString(directResponse.getResult());
            responseObject = Collections.singleton(new ExtDirectResponseRaw(directResponse, jsonResult));
        }
        this.writeJsonResponse(response, responseObject, null, streamResponse);
    }

    private void handleMethodCallsSequential(List<ExtDirectRequest> directRequests, HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        ArrayList<BaseResponse> directResponses = new ArrayList<BaseResponse>(directRequests.size());
        boolean streamResponse = this.configurationService.getConfiguration().isStreamResponse();
        ObjectMapper objectMapper = this.configurationService.getJsonHandler().getMapper();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = this.handleMethodCall(directRequest, request, response, locale);
            streamResponse = streamResponse || directResponse.isStreamResponse();
            Class<?> jsonView = directResponse.getJsonView();
            if (jsonView == null) {
                directResponses.add(directResponse);
                continue;
            }
            String jsonResult = objectMapper.writerWithView(jsonView).writeValueAsString(directResponse.getResult());
            directResponses.add(new ExtDirectResponseRaw(directResponse, jsonResult));
        }
        this.writeJsonResponse(response, directResponses, null, streamResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtDirectResponse handleMethodCall(ExtDirectRequest directRequest, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
        this.notifyExtRequestListenersBeforeRequest(directRequest, directResponse, request, response, locale);
        try {
            MethodInfo methodInfo = this.methodInfoCache.get(directRequest.getAction(), directRequest.getMethod());
            if (methodInfo != null) {
                try {
                    directResponse.setStreamResponse(methodInfo.isStreamResponse());
                    ExtDirectStoreResult<Object> result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                    if (result != null) {
                        ModelAndJsonView modelAndJsonView = null;
                        if (result instanceof ModelAndJsonView) {
                            modelAndJsonView = (ModelAndJsonView)((Object)result);
                            result = modelAndJsonView.getModel();
                        }
                        if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !(result instanceof ExtDirectFormLoadResult) && !(result instanceof EdFormLoadResult)) {
                            ExtDirectFormLoadResult formLoadResult = new ExtDirectFormLoadResult(result);
                            if (result instanceof JsonViewHint) {
                                formLoadResult.setJsonView(((JsonViewHint)result).getJsonView());
                            }
                            result = formLoadResult;
                        } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !(result instanceof ExtDirectStoreResult) && !(result instanceof EdStoreResult) && this.configurationService.getConfiguration().isAlwaysWrapStoreResponse()) {
                            result = result instanceof Collection ? new ExtDirectStoreResult((Collection)((Object)result)) : new ExtDirectStoreResult<Map<String, Object>>((Map<String, Object>)((Object)result));
                        } else if (methodInfo.isType(ExtDirectMethodType.FORM_POST_JSON)) {
                            if (result instanceof ExtDirectFormPostResult) {
                                ExtDirectFormPostResult formPostResult = (ExtDirectFormPostResult)((Object)result);
                                result = formPostResult.getResult();
                            } else if (result instanceof EdFormPostResult) {
                                EdFormPostResult formPostResult = (EdFormPostResult)((Object)result);
                                result = formPostResult.result();
                            }
                        }
                        directResponse.setResult(result);
                        if (modelAndJsonView != null) {
                            directResponse.setJsonView(RouterController.getJsonView(modelAndJsonView, methodInfo.getJsonView()));
                        } else {
                            directResponse.setJsonView(RouterController.getJsonView(result, methodInfo.getJsonView()));
                        }
                    } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                        directResponse.setResult(Collections.emptyList());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                    directResponse.setResult(this.handleException(methodInfo, directResponse, e, request));
                }
            } else {
                log.error((Object)("Error invoking method '" + directRequest.getAction() + "." + directRequest.getMethod() + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directResponse, directRequest.getAction(), directRequest.getMethod());
            }
            ExtDirectResponse extDirectResponse = directResponse;
            return extDirectResponse;
        }
        finally {
            this.notifyExtRequestListenersAfterRequest(directRequest, directResponse, request, response, locale);
        }
    }

    private void notifyExtRequestListenersBeforeRequest(ExtDirectRequest directRequest, ExtDirectResponse directResponse, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (this.extRequestListeners != null) {
            for (ExtRequestListener extrl : this.extRequestListeners) {
                extrl.beforeRequest(directRequest, directResponse, request, response, locale);
            }
        }
    }

    private void notifyExtRequestListenersAfterRequest(ExtDirectRequest directRequest, ExtDirectResponse directResponse, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (this.extRequestListeners != null) {
            for (ExtRequestListener extrl : this.extRequestListeners) {
                extrl.afterRequest(directRequest, directResponse, request, response, locale);
            }
        }
    }

    public void writeJsonResponse(HttpServletRequest request, HttpServletResponse response, Object responseObject, Class<?> jsonView) throws IOException {
        this.writeJsonResponse(response, responseObject, jsonView, this.configurationService.getConfiguration().isStreamResponse(), ExtDirectSpringUtil.isMultipart(request));
    }

    private void writeJsonResponse(HttpServletResponse response, Object responseObject, Class<?> jsonView, boolean streamResponse) throws IOException {
        this.writeJsonResponse(response, responseObject, jsonView, streamResponse, false);
    }

    public void writeJsonResponse(HttpServletResponse response, Object responseObject, Class<?> jsonView, boolean streamResponse, boolean isMultipart) throws IOException {
        ObjectMapper objectMapper = this.configurationService.getJsonHandler().getMapper();
        if (isMultipart) {
            response.setContentType(TEXT_HTML.toString());
            response.setCharacterEncoding(TEXT_HTML.getCharset().name());
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            bos.write("<html><body><textarea>".getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            String responseJson = jsonView == null ? objectMapper.writeValueAsString(responseObject) : objectMapper.writerWithView(jsonView).writeValueAsString(responseObject);
            responseJson = responseJson.replace("&quot;", "\\&quot;");
            bos.write(responseJson.getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            String frameDomain = this.configurationService.getConfiguration().getFrameDomain();
            String frameDomainScript = "";
            if (frameDomain != null) {
                frameDomainScript = String.format(this.configurationService.getConfiguration().getFrameDomainScript(), frameDomain);
            }
            bos.write(("</textarea>" + frameDomainScript + "</body></html>").getBytes(ExtDirectSpringUtil.UTF8_CHARSET));
            response.setContentLength(bos.size());
            FileCopyUtils.copy((byte[])bos.toByteArray(), (OutputStream)response.getOutputStream());
        } else {
            response.setContentType(APPLICATION_JSON.toString());
            response.setCharacterEncoding(APPLICATION_JSON.getCharset().name());
            ServletOutputStream outputStream = response.getOutputStream();
            if (!streamResponse) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                JsonGenerator jsonGenerator = objectMapper.getFactory().createGenerator((OutputStream)bos, JsonEncoding.UTF8);
                if (jsonView == null) {
                    objectMapper.writeValue(jsonGenerator, responseObject);
                } else {
                    objectMapper.writerWithView(jsonView).writeValue(jsonGenerator, responseObject);
                }
                response.setContentLength(bos.size());
                outputStream.write(bos.toByteArray());
                jsonGenerator.close();
            } else {
                JsonGenerator jsonGenerator = objectMapper.getFactory().createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
                if (jsonView == null) {
                    objectMapper.writeValue(jsonGenerator, responseObject);
                } else {
                    objectMapper.writerWithView(jsonView).writeValue(jsonGenerator, responseObject);
                }
                jsonGenerator.close();
            }
            outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object[] parameters = this.configurationService.getParametersResolver().resolveParameters(request, response, locale, directRequest, methodInfo);
        if ((this.configurationService.getConfiguration().isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.configurationService.getApplicationContext(), directRequest.getAction(), methodInfo, parameters);
    }

    private Object handleException(MethodInfo methodInfo, BaseResponse response, Exception e, HttpServletRequest request) {
        return this.configurationService.getRouterExceptionHandler().handleException(methodInfo, response, e, request);
    }

    private void handleMethodNotFoundError(BaseResponse response, String beanName, String methodName) {
        response.setType("exception");
        response.setMessage(this.configurationService.getConfiguration().getDefaultExceptionMessage());
        if (this.configurationService.getConfiguration().isSendStacktrace()) {
            response.setWhere("Bean or Method '" + beanName + "." + methodName + "' not found");
        } else {
            response.setWhere(null);
        }
    }

    private static Class<?> getJsonView(Object result, Class<?> defaultJsonView) {
        Class<?> jsonView;
        if (result instanceof JsonViewHint && (jsonView = ((JsonViewHint)result).getJsonView()) != null) {
            if (jsonView != ExtDirectMethod.NoJsonView.class) {
                return jsonView;
            }
            return null;
        }
        return defaultJsonView;
    }
}

