package ch.ralscha.extdirectspring.bean;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.springframework.lang.Nullable;

/**
 * Immutable implementation of {@link EdFormLoadResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEdFormLoadResult.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEdFormLoadResult.of()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "EdFormLoadResult"})
final class ImmutableEdFormLoadResult extends EdFormLoadResult {
  private final @Nullable Object data;
  private final boolean success;

  private ImmutableEdFormLoadResult(@Nullable Object data, boolean success) {
    this.data = data;
    this.success = success;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public @Nullable Object data() {
    return data;
  }

  /**
   * @return The value of the {@code success} attribute
   */
  @JsonProperty("success")
  @Override
  public boolean success() {
    return success;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdFormLoadResult#data() data} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for data (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdFormLoadResult withData(@Nullable Object value) {
    if (this.data == value) return this;
    return new ImmutableEdFormLoadResult(value, this.success);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EdFormLoadResult#success() success} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for success
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEdFormLoadResult withSuccess(boolean value) {
    if (this.success == value) return this;
    return new ImmutableEdFormLoadResult(this.data, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEdFormLoadResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEdFormLoadResult
        && equalTo((ImmutableEdFormLoadResult) another);
  }

  private boolean equalTo(ImmutableEdFormLoadResult another) {
    return Objects.equals(data, another.data)
        && success == another.success;
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code success}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Boolean.hashCode(success);
    return h;
  }

  /**
   * Prints the immutable value {@code EdFormLoadResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EdFormLoadResult{"
        + "data=" + data
        + ", success=" + success
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends EdFormLoadResult {
    Object data;
    boolean success;
    boolean successIsSet;
    @JsonProperty("data")
    public void setData(@Nullable Object data) {
      this.data = data;
    }
    @JsonProperty("success")
    public void setSuccess(boolean success) {
      this.success = success;
      this.successIsSet = true;
    }
    @Override
    public Object data() { throw new UnsupportedOperationException(); }
    @Override
    public boolean success() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEdFormLoadResult fromJson(Json json) {
    ImmutableEdFormLoadResult.Builder builder = ImmutableEdFormLoadResult.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.successIsSet) {
      builder.success(json.success);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code EdFormLoadResult} instance.
   * @param data The value for the {@code data} attribute
   * @param success The value for the {@code success} attribute
   * @return An immutable EdFormLoadResult instance
   */
  public static ImmutableEdFormLoadResult of(@Nullable Object data, boolean success) {
    return new ImmutableEdFormLoadResult(data, success);
  }

  /**
   * Creates an immutable copy of a {@link EdFormLoadResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EdFormLoadResult instance
   */
  public static ImmutableEdFormLoadResult copyOf(EdFormLoadResult instance) {
    if (instance instanceof ImmutableEdFormLoadResult) {
      return (ImmutableEdFormLoadResult) instance;
    }
    return ImmutableEdFormLoadResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEdFormLoadResult ImmutableEdFormLoadResult}.
   * @return A new ImmutableEdFormLoadResult builder
   */
  public static ImmutableEdFormLoadResult.Builder builder() {
    return new ImmutableEdFormLoadResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEdFormLoadResult ImmutableEdFormLoadResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SUCCESS = 0x1L;
    private long initBits = 0x1L;

    private Object data;
    private boolean success;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EdFormLoadResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EdFormLoadResult instance) {
      Objects.requireNonNull(instance, "instance");
      Object dataValue = instance.data();
      if (dataValue != null) {
        data(dataValue);
      }
      success(instance.success());
      return this;
    }

    /**
     * Initializes the value for the {@link EdFormLoadResult#data() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Object data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link EdFormLoadResult#success() success} attribute.
     * @param success The value for success 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("success")
    public final Builder success(boolean success) {
      this.success = success;
      initBits &= ~INIT_BIT_SUCCESS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEdFormLoadResult ImmutableEdFormLoadResult}.
     * @return An immutable instance of EdFormLoadResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEdFormLoadResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEdFormLoadResult(data, success);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SUCCESS) != 0) attributes.add("success");
      return "Cannot build EdFormLoadResult, some of required attributes are not set " + attributes;
    }
  }
}
