/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Service
public class MethodRegistrar
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Log log = LogFactory.getLog(RouterController.class);
    private final MethodInfoCache methodInfoCache;

    @Autowired
    public MethodRegistrar(MethodInfoCache methodInfoCache) {
        this.methodInfoCache = methodInfoCache;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        String[] beanNames;
        ApplicationContext context = (ApplicationContext)event.getSource();
        for (String beanName : beanNames = context.getBeanNamesForType(Object.class)) {
            Class handlerType = context.getType(beanName);
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            Set methods = MethodIntrospector.selectMethods((Class)userType, method -> AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class) != null);
            for (Method method2 : methods) {
                ExtDirectMethod directMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method2, ExtDirectMethod.class);
                String beanAndMethodName = beanName + "." + method2.getName();
                if (!directMethodAnnotation.value().isValid(beanAndMethodName, userType, method2)) continue;
                this.methodInfoCache.put(beanName, handlerType, method2, event.getApplicationContext());
                if (!log.isDebugEnabled()) continue;
                String info = "Register " + beanAndMethodName + "(" + (Object)((Object)directMethodAnnotation.value());
                if (StringUtils.hasText((String)directMethodAnnotation.group())) {
                    info = info + ", " + directMethodAnnotation.group();
                }
                info = info + ")";
                log.debug((Object)info);
            }
        }
    }

    public int getOrder() {
        return 2147482647;
    }
}

