/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.annotation;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.bean.EdFormPostResult;
import ch.ralscha.extdirectspring.bean.ExtDirectFormPostResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public enum ExtDirectMethodType {
    SIMPLE{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            Annotation[][] allParameterAnnotations;
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("SIMPLE method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("SIMPLE method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            Annotation[][] annotationArray = allParameterAnnotations = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] paramAnnotations;
                for (Annotation paramAnnotation : paramAnnotations = annotationArray[i]) {
                    if (!RequestParam.class.isInstance(paramAnnotation)) continue;
                    log.error((Object)("SIMPLE method '" + beanAndMethodName + "' contains a non supported parameter annotation @RequestParam"));
                    return false;
                }
            }
            return true;
        }
    }
    ,
    SIMPLE_NAMED{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("SIMPLE_NAMED method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("SIMPLE_NAMED method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    FORM_LOAD{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("FORM_LOAD method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("FORM_LOAD method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    STORE_READ{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("STORE_READ method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("STORE_READ method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    STORE_MODIFY{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("STORE_MODIFY method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    FORM_POST{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            boolean isValid = true;
            if (method.getReturnType().equals(ExtDirectFormPostResult.class) || method.getReturnType().equals(EdFormPostResult.class)) {
                ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
                if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
                }
                if (extDirectMethodAnnotation.entryClass() != Object.class) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
                }
                if (!extDirectMethodAnnotation.batched()) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support batched attribute of @ExtDirectMethod"));
                }
                isValid = true;
            } else if (method.getReturnType().equals(Void.TYPE)) {
                ExtDirectMethod extDirectMethodAnnotation;
                RequestMapping methodAnnotation;
                if (AnnotationUtils.findAnnotation((Method)method, ResponseBody.class) != null) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' should not have a @ResponseBody annotation"));
                }
                if (AnnotationUtils.findAnnotation(clazz, Controller.class) == null) {
                    log.error((Object)("FORM_POST method '" + beanAndMethodName + "' must be a member of a @Controller bean"));
                    isValid = false;
                }
                if ((methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class)) == null) {
                    log.error((Object)("FORM_POST method '" + beanAndMethodName + "' must be annotated with @RequestMapping"));
                    isValid = false;
                }
                RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
                boolean hasValue = false;
                if (classAnnotation != null) {
                    boolean bl = hasValue = classAnnotation.value() != null && classAnnotation.value().length > 0;
                }
                if (methodAnnotation != null && !hasValue) {
                    boolean bl = hasValue = methodAnnotation.value() != null && methodAnnotation.value().length > 0;
                }
                if (!hasValue) {
                    log.error((Object)("FORM_POST method '" + beanAndMethodName + "' must have a @RequestMapping annotation with a value"));
                    isValid = false;
                }
                if (methodAnnotation != null) {
                    boolean hasPostRequestMethod = false;
                    for (RequestMethod requestMethod : methodAnnotation.method()) {
                        if (!requestMethod.equals((Object)RequestMethod.POST)) continue;
                        hasPostRequestMethod = true;
                        break;
                    }
                    if (!hasPostRequestMethod) {
                        log.error((Object)("FORM_POST method '" + beanAndMethodName + "' must have a @RequestMapping annotation with method = RequestMethod.POST"));
                        isValid = false;
                    }
                }
                if (!(extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class)).batched()) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support batched attribute of @ExtDirectMethod"));
                }
                if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
                }
                if (extDirectMethodAnnotation.entryClass() != Object.class) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
                }
                if (extDirectMethodAnnotation.synchronizeOnSession()) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support synchronizeOnSession attribute of @ExtDirectMethod"));
                }
                if (extDirectMethodAnnotation.streamResponse()) {
                    log.warn((Object)("FORM_POST method '" + beanAndMethodName + "' does not support streamResponse attribute of @ExtDirectMethod"));
                }
            } else {
                log.error((Object)("FORM_POST method '" + beanAndMethodName + "' must return void or an instance of ExtDirectFormPostResult or EdFormPostResult"));
                isValid = false;
            }
            return isValid;
        }
    }
    ,
    TREE_LOAD{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("TREE_LOAD method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("TREE_LOAD method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    POLL{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("POLL method '" + beanAndMethodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            if (!extDirectMethodAnnotation.batched()) {
                log.warn((Object)("POLL method '" + beanAndMethodName + "' does not support batched attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    FORM_POST_JSON{

        @Override
        public boolean isValid(String beanAndMethodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("FORM_POST_JSON method '" + beanAndMethodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (!extDirectMethodAnnotation.batched()) {
                log.warn((Object)("FORM_POST_JSON method '" + beanAndMethodName + "' does not support batched attribute of @ExtDirectMethod"));
            }
            for (Class<Object> clazz2 : method.getParameterTypes()) {
                if (clazz2.isAssignableFrom(BindingResult.class)) {
                    log.error((Object)("FORM_POST_JSON method '" + beanAndMethodName + "' must not have a BindingResult parameter"));
                    return false;
                }
                if (!clazz2.isAssignableFrom(MultipartFile.class)) continue;
                log.error((Object)("FORM_POST_JSON method '" + beanAndMethodName + "' must not have a MultipartFile parameter"));
                return false;
            }
            return true;
        }
    };

    static final Log log;

    public abstract boolean isValid(String var1, Class<?> var2, Method var3);

    static {
        log = LogFactory.getLog(ExtDirectMethodType.class);
    }
}

