/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import ch.ralscha.extdirectspring.filter.BooleanFilter;
import ch.ralscha.extdirectspring.filter.Comparison;
import ch.ralscha.extdirectspring.filter.DateFilter;
import ch.ralscha.extdirectspring.filter.ListFilter;
import ch.ralscha.extdirectspring.filter.NumericFilter;
import ch.ralscha.extdirectspring.filter.StringFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

public class Filter {
    private final String field;
    private final String rawComparison;
    private final Comparison comparison;

    public Filter(String field, String rawComparison, Comparison comparison) {
        this.field = field;
        this.rawComparison = rawComparison;
        this.comparison = comparison;
    }

    public String getField() {
        return this.field;
    }

    public String getRawComparison() {
        return this.rawComparison;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public String getOperator() {
        return this.rawComparison;
    }

    public static Filter createFilter(Map<String, Object> jsonData, ConversionService conversionService) {
        String type = (String)jsonData.get("type");
        Object source = jsonData.get("value");
        String rawComparison = Filter.extractRawComparison(jsonData);
        Comparison comparisonFromJson = Comparison.fromString(rawComparison);
        String property = (String)jsonData.get("property");
        if (property == null) {
            property = (String)jsonData.get("field");
        }
        if (type == null) {
            if (property != null) {
                if (source instanceof Number) {
                    return new NumericFilter(property, (Number)source, rawComparison, comparisonFromJson);
                }
                if (source instanceof Boolean) {
                    return new BooleanFilter(property, (Boolean)source, rawComparison, comparisonFromJson);
                }
                if (source instanceof List) {
                    return new ListFilter(property, (List)source, rawComparison, comparisonFromJson);
                }
                return new StringFilter(property, source != null ? source.toString() : null, rawComparison, comparisonFromJson);
            }
            return null;
        }
        if (type.equals("numeric") || type.equals("int") || type.equals("float") || type.equals("number")) {
            Number value = (Number)conversionService.convert(source, Number.class);
            return new NumericFilter(property, value, rawComparison, comparisonFromJson);
        }
        if (type.equals("string")) {
            return new StringFilter(property, (String)source, rawComparison, comparisonFromJson);
        }
        if (type.equals("date")) {
            return new DateFilter(property, (String)source, rawComparison, comparisonFromJson);
        }
        if (type.equals("list") || type.equals("combo")) {
            if (source instanceof String) {
                String[] values = ((String)source).split(",");
                return new ListFilter<String>(property, Arrays.asList(values), rawComparison, comparisonFromJson);
            }
            return new ListFilter(property, (List)source, rawComparison, comparisonFromJson);
        }
        if (type.equals("boolean")) {
            return new BooleanFilter(property, (Boolean)source, rawComparison, comparisonFromJson);
        }
        return null;
    }

    private static String extractRawComparison(Map<String, Object> jsonData) {
        String comparison = (String)jsonData.get("comparison");
        if (comparison != null) {
            return comparison;
        }
        return (String)jsonData.get("operator");
    }
}

