/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectDocParameters;
import ch.ralscha.extdirectspring.annotation.ExtDirectDocReturn;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodDocumentation;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.api.Action;
import ch.ralscha.extdirectspring.bean.api.ActionDoc;
import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;

public final class MethodInfo {
    private final String group;
    private final ExtDirectMethodType type;
    private final Class<?> jsonView;
    private final boolean synchronizeOnSession;
    private final boolean streamResponse;
    private List<ParameterInfo> parameters;
    private Method method;
    private String forwardPath;
    private HandlerMethod handlerMethod;
    private Class<?> collectionType;
    private Action action;
    private PollingProvider pollingProvider;

    public MethodInfo(Class<?> clazz, ApplicationContext context, String beanName, Method method) {
        ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
        this.type = extDirectMethodAnnotation.value();
        this.jsonView = extDirectMethodAnnotation.jsonView() != ExtDirectMethod.NoJsonView.class ? extDirectMethodAnnotation.jsonView() : null;
        this.group = StringUtils.hasText((String)extDirectMethodAnnotation.group()) ? extDirectMethodAnnotation.group().trim() : null;
        this.synchronizeOnSession = extDirectMethodAnnotation.synchronizeOnSession();
        this.streamResponse = extDirectMethodAnnotation.streamResponse();
        if (this.type != ExtDirectMethodType.FORM_POST) {
            this.method = method;
            this.parameters = MethodInfo.buildParameterList(clazz, method);
            Class<?> clazz2 = this.collectionType = extDirectMethodAnnotation.entryClass() == Object.class ? null : extDirectMethodAnnotation.entryClass();
            if (this.collectionType == null) {
                for (ParameterInfo parameter : this.parameters) {
                    Class<?> collType = parameter.getCollectionType();
                    if (collType == null) continue;
                    this.collectionType = collType;
                    break;
                }
            }
        } else if (method.getReturnType().equals(Void.TYPE)) {
            RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
            Object path = null;
            if (MethodInfo.hasValue(classAnnotation)) {
                path = classAnnotation.value()[0];
            }
            if (MethodInfo.hasValue(methodAnnotation)) {
                String methodPath = methodAnnotation.value()[0];
                path = path != null ? (String)path + methodPath : methodPath;
            }
            if (path != null) {
                if (((String)path).charAt(0) == '/' && ((String)path).length() > 1) {
                    path = ((String)path).substring(1, ((String)path).length());
                }
                this.forwardPath = "forward:" + (String)path;
            }
        } else {
            this.handlerMethod = new HandlerMethod(beanName, (BeanFactory)context, method).createWithResolvedBean();
        }
        switch (this.type) {
            case SIMPLE: {
                int paramLength = 0;
                for (ParameterInfo parameter : this.parameters) {
                    if (!parameter.isClientParameter()) continue;
                    ++paramLength;
                }
                this.action = Action.create(method.getName(), paramLength, extDirectMethodAnnotation.batched());
                break;
            }
            case SIMPLE_NAMED: {
                int noOfClientParameters = 0;
                Class<?> parameterType = null;
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (ParameterInfo parameter : this.parameters) {
                    if (!parameter.isClientParameter()) continue;
                    ++noOfClientParameters;
                    parameterType = parameter.getType();
                    parameterNames.add(parameter.getName());
                }
                if (noOfClientParameters == 1 && Map.class.isAssignableFrom(parameterType)) {
                    this.action = Action.createNamed(method.getName(), Collections.emptyList(), Boolean.FALSE, extDirectMethodAnnotation.batched());
                    break;
                }
                this.action = Action.createNamed(method.getName(), Collections.unmodifiableList(parameterNames), null, extDirectMethodAnnotation.batched());
                break;
            }
            case FORM_LOAD: 
            case FORM_POST_JSON: {
                this.action = Action.create(method.getName(), 1, extDirectMethodAnnotation.batched());
                break;
            }
            case STORE_READ: 
            case STORE_MODIFY: 
            case TREE_LOAD: {
                ArrayList<String> metadataParams = new ArrayList<String>();
                for (ParameterInfo parameter : this.parameters) {
                    if (!parameter.hasMetadataParamAnnotation()) continue;
                    metadataParams.add(parameter.getName());
                }
                this.action = Action.createTreeLoad(method.getName(), 1, metadataParams, extDirectMethodAnnotation.batched());
                break;
            }
            case FORM_POST: {
                this.action = Action.createFormHandler(method.getName(), 0);
                break;
            }
            case POLL: {
                this.pollingProvider = new PollingProvider(beanName, method.getName(), extDirectMethodAnnotation.event());
                break;
            }
            default: {
                throw new IllegalStateException("ExtDirectMethodType: " + this.type + " does not exists");
            }
        }
        this.action = this.extractDocumentationAnnotations(extDirectMethodAnnotation.documentation());
    }

    private Action extractDocumentationAnnotations(ExtDirectMethodDocumentation documentation) {
        if (!documentation.value().isEmpty()) {
            ExtDirectDocReturn docReturn;
            ActionDoc actionDoc = new ActionDoc(this.getAction(), documentation.value(), documentation.author(), documentation.version(), documentation.deprecated());
            ExtDirectDocParameters docParameters = documentation.parameters();
            if (null != docParameters) {
                String[] descriptions;
                String[] params = docParameters.params();
                String[] stringArray = descriptions = docParameters.descriptions() == null ? new String[params.length] : docParameters.descriptions();
                if (params.length == descriptions.length) {
                    for (int i = 0; i < params.length; ++i) {
                        actionDoc.getParameters().put(params[i], descriptions[i] == null ? "No description" : descriptions[i]);
                    }
                } else {
                    LogFactory.getLog(MethodInfo.class).info((Object)"Documentation: skip generation of parameters, params size is different from descriptions size");
                }
            }
            if (null != (docReturn = documentation.returnMethod())) {
                String[] descriptions;
                String[] properties = docReturn.properties();
                String[] stringArray = descriptions = docReturn.descriptions() == null ? new String[properties.length] : docReturn.descriptions();
                if (properties.length == descriptions.length) {
                    for (int i = 0; i < properties.length; ++i) {
                        actionDoc.getReturnMethod().put(properties[i], descriptions[i] == null ? "No description" : descriptions[i]);
                    }
                } else {
                    LogFactory.getLog(MethodInfo.class).info((Object)"Documentation: skip generation of return method properties, properties size is different from descriptions size");
                }
            }
            return actionDoc;
        }
        return this.action;
    }

    private static boolean hasValue(RequestMapping requestMapping) {
        return requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0 && StringUtils.hasText((String)requestMapping.value()[0]);
    }

    private static List<ParameterInfo> buildParameterList(Class<?> clazz, Method method) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Method methodWithAnnotation = MethodInfo.findMethodWithAnnotation(method, ExtDirectMethod.class);
        if (methodWithAnnotation == null) {
            methodWithAnnotation = method;
        }
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            params.add(new ParameterInfo(clazz, methodWithAnnotation, paramIndex));
        }
        return params;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public boolean isType(ExtDirectMethodType methodType) {
        return this.type == methodType;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public boolean isStreamResponse() {
        return this.streamResponse;
    }

    public PollingProvider getPollingProvider() {
        return this.pollingProvider;
    }

    public Action getAction() {
        return this.action;
    }

    public String getGroup() {
        return this.group;
    }

    public static Method findMethodWithAnnotation(Method method, Class<? extends Annotation> annotation) {
        if (method.isAnnotationPresent(annotation)) {
            return method;
        }
        for (Class<?> cl = method.getDeclaringClass(); cl != null && cl != Object.class; cl = cl.getSuperclass()) {
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (!equivalentMethod.isAnnotationPresent(annotation)) continue;
                return equivalentMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

