/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Action {
    private final String name;
    private final Integer len;
    private final Boolean batched;
    private final List<String> params;
    private final Boolean formHandler;
    private final Boolean strict;
    private final Metadata metadata;

    public static Action create(String name, Integer len) {
        return new Action(name, len, null, null, null, null, null);
    }

    public static Action create(String name, Integer len, Boolean batched) {
        return new Action(name, len, batched, null, null, null, null);
    }

    public static Action createFormHandler(String name, Integer len) {
        return new Action(name, len, null, Boolean.TRUE, null, null, null);
    }

    public static Action createTreeLoad(String name, Integer len, List<String> metadataParams, Boolean batched) {
        return new Action(name, len, batched, null, null, null, metadataParams);
    }

    public static Action createNamed(String name, List<String> params, Boolean strict, Boolean batched) {
        return new Action(name, null, batched, null, params, strict, null);
    }

    Action(String name, Integer len, Boolean batched, Boolean formHandler, List<String> params, Boolean strict, List<String> metadataParams) {
        this.name = name;
        this.len = len;
        this.batched = batched != null && batched == false ? batched : null;
        this.formHandler = formHandler != null && formHandler != false ? formHandler : null;
        this.params = params != null ? params : null;
        this.strict = strict != null && strict == false ? strict : null;
        this.metadata = metadataParams != null && !metadataParams.isEmpty() ? new Metadata(this, metadataParams) : null;
    }

    public Action(Action toCopy) {
        this.name = toCopy.name;
        this.len = toCopy.len;
        this.formHandler = toCopy.formHandler;
        this.params = toCopy.params;
        this.strict = toCopy.strict;
        this.metadata = toCopy.metadata;
        this.batched = toCopy.batched;
    }

    public Boolean getFormHandler() {
        return this.formHandler;
    }

    public Integer getLen() {
        return this.len;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParams() {
        return this.params;
    }

    public Boolean getStrict() {
        return this.strict;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Boolean getBatched() {
        return this.batched;
    }

    class Metadata {
        private final List<String> params;

        Metadata(Action this$0, List<String> params) {
            this.params = params;
        }

        public List<String> getParams() {
            return this.params;
        }
    }
}

