/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.ApiCacheKey;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class ApiCache {
    private final Map<ApiCacheKey, SoftReference<String>> cache = new ConcurrentHashMap<ApiCacheKey, SoftReference<String>>();

    public void put(ApiCacheKey key, String apiString) {
        this.cache.put(key, new SoftReference<String>(apiString));
    }

    public String get(ApiCacheKey key) {
        SoftReference<String> apiStringReference;
        if (key != null && (apiStringReference = this.cache.get(key)) != null && apiStringReference.get() != null) {
            return apiStringReference.get();
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }
}

