/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Service
public class MethodInfoCache
implements Iterable<Map.Entry<Key, MethodInfo>> {
    private static final Log log = LogFactory.getLog(MethodInfoCache.class);
    private final Map<Key, MethodInfo> cache = new HashMap<Key, MethodInfo>();

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void put(String beanName, Class<?> clazz, Method method, ApplicationContext context) {
        MethodInfo info = new MethodInfo(clazz, context, beanName, method);
        this.cache.put(new Key(beanName, method.getName()), info);
    }

    public MethodInfo get(String beanName, String methodName) {
        return this.cache.get(new Key(beanName, methodName));
    }

    @Override
    public Iterator<Map.Entry<Key, MethodInfo>> iterator() {
        return this.cache.entrySet().iterator();
    }

    public void clear() {
        this.cache.clear();
    }

    public void populateMethodInfoCache(ApplicationContext context) {
        String[] beanNames;
        for (String beanName : beanNames = context.getBeanNamesForType(Object.class)) {
            Class handlerType = context.getType(beanName);
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            Set methods = MethodIntrospector.selectMethods((Class)userType, method -> AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class) != null);
            for (Method method2 : methods) {
                ExtDirectMethod directMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method2, ExtDirectMethod.class);
                String beanAndMethodName = beanName + "." + method2.getName();
                if (!directMethodAnnotation.value().isValid(beanAndMethodName, userType, method2)) continue;
                this.put(beanName, handlerType, method2, context);
                if (!log.isDebugEnabled()) continue;
                String info = "Register " + beanAndMethodName + "(" + String.valueOf((Object)directMethodAnnotation.value());
                if (StringUtils.hasText((String)directMethodAnnotation.group())) {
                    info = info + ", " + directMethodAnnotation.group();
                }
                info = info + ")";
                log.debug((Object)info);
            }
        }
    }

    public static final class Key {
        private final String beanName;
        private final String methodName;

        public Key(String beanName, String methodName) {
            this.beanName = beanName;
            this.methodName = methodName;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return ExtDirectSpringUtil.equal(this.beanName, other.beanName) && ExtDirectSpringUtil.equal(this.methodName, other.methodName);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.beanName, this.methodName});
        }
    }
}

