/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.bean.api.RemotingApi;
import ch.ralscha.extdirectspring.bean.api.RemotingApiMixin;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.controller.ConfigurationService;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.ApiCache;
import ch.ralscha.extdirectspring.util.ApiCacheKey;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ApiController {
    private final ConfigurationService configurationService;
    private final MethodInfoCache methodInfoCache;
    private final ApiCache apiCache;
    private final ObjectMapper objectMapper;

    @Autowired
    public ApiController(ConfigurationService configurationService, MethodInfoCache methodInfoCache, ApiCache apiCache) {
        this.configurationService = configurationService;
        this.methodInfoCache = methodInfoCache;
        this.apiCache = apiCache;
        this.objectMapper = new ObjectMapper();
    }

    @RequestMapping(value={"/api.js", "/api-debug.js", "/api-debug-doc.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false) String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false) String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false) String pollingUrlsVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false) Boolean fullRouterUrl, @RequestParam(value="format", required=false) String format, @RequestParam(value="baseRouterUrl", required=false) String baseRouterUrl, HttpServletRequest request, @RequestParam(value="cache", required=false, defaultValue="true") boolean cache, HttpServletResponse response) throws IOException {
        if (format == null) {
            response.setContentType(this.configurationService.getConfiguration().getJsContentType());
            response.setCharacterEncoding(ExtDirectSpringUtil.UTF8_CHARSET.name());
            String apiString = this.buildAndCacheApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, group, fullRouterUrl, baseRouterUrl, request, cache);
            byte[] outputBytes = apiString.getBytes(ExtDirectSpringUtil.UTF8_CHARSET);
            response.setContentLength(outputBytes.length);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(outputBytes);
            outputStream.flush();
        } else {
            response.setContentType(RouterController.APPLICATION_JSON.toString());
            response.setCharacterEncoding(RouterController.APPLICATION_JSON.getCharset().name());
            String requestUrlString = request.getRequestURL().toString();
            boolean debug = requestUrlString.contains("api-debug.js");
            String routerUrl = requestUrlString.replaceFirst("api[^/]*?\\.js", "router");
            String apiString = this.buildApiJson(apiNs, actionNs, remotingApiVar, routerUrl, group, debug, cache);
            byte[] outputBytes = apiString.getBytes(ExtDirectSpringUtil.UTF8_CHARSET);
            response.setContentLength(outputBytes.length);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(outputBytes);
            outputStream.flush();
        }
    }

    @RequestMapping(value={"/api-{fingerprint}.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false) String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false) String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false) String pollingUrlsVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false) Boolean fullRouterUrl, @RequestParam(value="baseRouterUrl", required=false) String baseRouterUrl, HttpServletRequest request, @RequestParam(value="cache", required=false, defaultValue="true") boolean cache, HttpServletResponse response) throws IOException {
        String apiString = this.buildAndCacheApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, group, fullRouterUrl, baseRouterUrl, request, cache);
        byte[] outputBytes = apiString.getBytes(ExtDirectSpringUtil.UTF8_CHARSET);
        ExtDirectSpringUtil.handleCacheableResponse(request, response, outputBytes, this.configurationService.getConfiguration().getJsContentType());
    }

    private String buildAndCacheApiString(String requestApiNs, String requestActionNs, String requestRemotingApiVar, String requestPollingUrlsVar, String group, Boolean requestFullRouterUrl, String requestBaseRouterUrl, HttpServletRequest request, boolean cache) {
        String baseRouterUrl;
        Configuration configuration = this.configurationService.getConfiguration();
        String apiNs = requestApiNs != null ? requestApiNs : configuration.getApiNs();
        String remotingApiVar = requestRemotingApiVar != null ? requestRemotingApiVar : configuration.getRemotingApiVar();
        String pollingUrlsVar = requestPollingUrlsVar != null ? requestPollingUrlsVar : configuration.getPollingUrlsVar();
        boolean fullRouterUrl = requestFullRouterUrl != null ? requestFullRouterUrl.booleanValue() : configuration.isFullRouterUrl();
        String actionNs = requestActionNs != null ? requestActionNs : configuration.getActionNs();
        String string = baseRouterUrl = requestBaseRouterUrl != null ? requestBaseRouterUrl : configuration.getBaseRouterUrl();
        Object requestUrlString = baseRouterUrl != null ? baseRouterUrl + (baseRouterUrl.endsWith("/") ? "" : "/") : (fullRouterUrl ? request.getRequestURL().toString() : request.getRequestURI());
        requestUrlString = configuration.postProcessRequestUrl(request, (String)requestUrlString);
        String stripApiRegex = "api[^/]*?\\.js";
        String routerUrl = ((String)requestUrlString).replaceFirst(stripApiRegex, "") + "router";
        String basePollUrl = ((String)requestUrlString).replaceFirst(stripApiRegex, "") + "poll";
        if (!((String)requestUrlString).contains("/api-debug-doc.js")) {
            boolean debug = ((String)requestUrlString).contains("api-debug.js");
            ApiCacheKey apiKey = new ApiCacheKey(apiNs, actionNs, remotingApiVar, pollingUrlsVar, routerUrl, group, debug);
            String apiString = this.apiCache.get(apiKey);
            if (apiString == null || !cache) {
                apiString = this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, routerUrl, basePollUrl, group, debug, false, cache);
                this.apiCache.put(apiKey, apiString);
            }
            return apiString;
        }
        return this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, routerUrl, basePollUrl, group, true, true, cache);
    }

    private String buildApiString(String apiNs, String actionNs, String remotingApiVar, String pollingUrlsVar, String routerUrl, String basePollUrl, String group, boolean debug, boolean doc, boolean cache) {
        String jsonConfig;
        RemotingApi remotingApi = new RemotingApi(this.configurationService.getConfiguration().getProviderType(), routerUrl, actionNs);
        remotingApi.setTimeout(this.configurationService.getConfiguration().getTimeout());
        remotingApi.setMaxRetries(this.configurationService.getConfiguration().getMaxRetries());
        Object enableBuffer = this.configurationService.getConfiguration().getEnableBuffer();
        if (enableBuffer instanceof String && StringUtils.hasText((String)((String)enableBuffer))) {
            String enableBufferString = (String)enableBuffer;
            if (enableBufferString.equalsIgnoreCase("true")) {
                remotingApi.setEnableBuffer(Boolean.TRUE);
            } else if (enableBufferString.equalsIgnoreCase("false")) {
                remotingApi.setEnableBuffer(Boolean.FALSE);
            } else {
                Integer enableBufferMs = (Integer)NumberUtils.parseNumber((String)enableBufferString, Integer.class);
                remotingApi.setEnableBuffer(enableBufferMs);
            }
        } else if (enableBuffer instanceof Number || enableBuffer instanceof Boolean) {
            remotingApi.setEnableBuffer(enableBuffer);
        }
        if (this.configurationService.getConfiguration().getBufferLimit() != null) {
            remotingApi.setBufferLimit(this.configurationService.getConfiguration().getBufferLimit());
        }
        this.buildRemotingApi(remotingApi, group, cache);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)apiNs)) {
            sb.append("Ext.ns('");
            sb.append(apiNs);
            sb.append("');");
        }
        if (debug) {
            sb.append("\n\n");
        }
        if (StringUtils.hasText((String)actionNs)) {
            sb.append("Ext.ns('");
            sb.append(actionNs);
            sb.append("');");
            if (debug) {
                sb.append("\n\n");
            }
        }
        if (!doc) {
            jsonConfig = this.writeValueAsString(remotingApi, debug);
        } else {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(RemotingApi.class, RemotingApiMixin.class);
            try {
                jsonConfig = mapper.writer().withDefaultPrettyPrinter().writeValueAsString((Object)remotingApi);
            }
            catch (JsonProcessingException e) {
                jsonConfig = null;
                LogFactory.getLog(ApiController.class).info((Object)"serialize object to json", (Throwable)e);
            }
        }
        if (StringUtils.hasText((String)apiNs)) {
            sb.append(apiNs).append(".");
        }
        sb.append(remotingApiVar).append(" = ");
        sb.append(jsonConfig);
        sb.append(";");
        List<PollingProvider> pollingProviders = remotingApi.getPollingProviders();
        if (!pollingProviders.isEmpty()) {
            if (debug) {
                sb.append("\n\n");
            }
            if (StringUtils.hasText((String)apiNs)) {
                sb.append(apiNs).append(".");
            }
            sb.append(pollingUrlsVar).append(" = {");
            if (debug) {
                sb.append("\n");
            }
            for (int i = 0; i < pollingProviders.size(); ++i) {
                if (debug) {
                    sb.append("  ");
                }
                sb.append("\"");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                sb.append(" : \"").append(basePollUrl).append("/");
                sb.append(pollingProviders.get(i).getBeanName());
                sb.append("/");
                sb.append(pollingProviders.get(i).getMethod());
                sb.append("/");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                if (i >= pollingProviders.size() - 1) continue;
                sb.append(",");
                if (!debug) continue;
                sb.append("\n");
            }
            if (debug) {
                sb.append("\n");
            }
            sb.append("};");
        }
        return sb.toString();
    }

    private String buildApiJson(String requestApiNs, String requestActionNs, String requestRemotingApiVar, String routerUrl, String group, boolean debug, boolean cache) {
        Configuration configuration = this.configurationService.getConfiguration();
        String apiNs = requestApiNs != null ? requestApiNs : configuration.getApiNs();
        String remotingApiVar = requestRemotingApiVar != null ? requestRemotingApiVar : configuration.getRemotingApiVar();
        String actionNs = requestActionNs != null ? requestActionNs : configuration.getActionNs();
        RemotingApi remotingApi = new RemotingApi(this.configurationService.getConfiguration().getProviderType(), routerUrl, actionNs);
        if (StringUtils.hasText((String)apiNs)) {
            remotingApi.setDescriptor(apiNs + "." + remotingApiVar);
        } else {
            remotingApi.setDescriptor(remotingApiVar);
        }
        this.buildRemotingApi(remotingApi, group, cache);
        return this.writeValueAsString(remotingApi, debug);
    }

    private void buildRemotingApi(RemotingApi remotingApi, String requestedGroup, boolean cache) {
        if (cache && this.methodInfoCache.isEmpty()) {
            this.methodInfoCache.populateMethodInfoCache(this.configurationService.getApplicationContext());
        } else {
            this.methodInfoCache.populateMethodInfoCache(this.configurationService.getApplicationContext());
        }
        String group = requestedGroup != null ? requestedGroup.trim() : requestedGroup;
        for (Map.Entry<MethodInfoCache.Key, MethodInfo> entry : this.methodInfoCache) {
            MethodInfo methodInfo = entry.getValue();
            if (!ApiController.isSameGroup(group, methodInfo.getGroup())) continue;
            if (methodInfo.getAction() != null) {
                remotingApi.addAction(entry.getKey().getBeanName(), methodInfo.getAction());
                continue;
            }
            if (methodInfo.getPollingProvider() == null) continue;
            remotingApi.addPollingProvider(methodInfo.getPollingProvider());
        }
    }

    private static boolean isSameGroup(String requestedGroups, String annotationGroups) {
        if (requestedGroups != null) {
            if (!requestedGroups.isEmpty() && annotationGroups != null && !annotationGroups.isEmpty()) {
                for (String requestedGroup : requestedGroups.split(",")) {
                    for (String annotationGroup : annotationGroups.split(",")) {
                        if (!ExtDirectSpringUtil.equal(requestedGroup, annotationGroup)) continue;
                        return true;
                    }
                }
            } else if (requestedGroups.isEmpty() && (annotationGroups == null || annotationGroups.trim().isEmpty())) {
                return true;
            }
            return false;
        }
        return true;
    }

    private String writeValueAsString(Object obj, boolean indent) {
        try {
            if (indent) {
                return this.objectMapper.writer().withDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"serialize object to json", (Throwable)e);
            return null;
        }
    }
}

