/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import java.util.Locale;

enum SupportedParameters {
    SERVLET_REQUEST(ServletRequest.class),
    SERVLET_RESPONSE(ServletResponse.class),
    SESSION(HttpSession.class),
    LOCALE(Locale.class),
    PRINCIPAL(Principal.class),
    EXT_DIRECT_REQUEST(ExtDirectRequest.class);

    private final Class<?> clazz;

    private SupportedParameters(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getSupportedClass() {
        return this.clazz;
    }

    public static boolean isSupported(Class<?> clazz) {
        if (clazz != null) {
            for (SupportedParameters supportedParameter : SupportedParameters.values()) {
                if (!supportedParameter.clazz.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object resolveParameter(Class<?> parameterType, HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest extDirectRequest) {
        if (SERVLET_REQUEST.getSupportedClass().isAssignableFrom(parameterType)) {
            return request;
        }
        if (SERVLET_RESPONSE.getSupportedClass().isAssignableFrom(parameterType)) {
            return response;
        }
        if (SESSION.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getSession();
        }
        if (PRINCIPAL.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (LOCALE.getSupportedClass().equals(parameterType)) {
            return locale;
        }
        if (EXT_DIRECT_REQUEST.getSupportedClass().equals(parameterType)) {
            return extDirectRequest;
        }
        return null;
    }
}

