/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.AbstractDisableable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.Application;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.fxbase.tree.PreorderSpliterator;
import org.jhotdraw8.fxcollection.typesafekey.Key;

public abstract class AbstractActivity
extends AbstractDisableable
implements Activity {
    protected final @NonNull ObjectProperty<Application> application = new SimpleObjectProperty((Object)this, "application");
    protected final @NonNull ObservableMap<Key<?>, Object> properties = FXCollections.observableHashMap();
    protected final @NonNull StringProperty title = new SimpleStringProperty((Object)this, "title", ApplicationLabels.getResources().getString("unnamedFile"));
    private final @NonNull IntegerProperty disambiguation = new SimpleIntegerProperty((Object)this, "disambiguation");
    private final @NonNull ReadOnlyMapProperty<String, Action> actions = new ReadOnlyMapWrapper(FXCollections.observableMap(new LinkedHashMap())).getReadOnlyProperty();

    @Override
    public @NonNull IntegerProperty disambiguationProperty() {
        return this.disambiguation;
    }

    protected abstract void initActions(@NonNull ObservableMap<String, Action> var1);

    protected abstract void initView();

    @Override
    public @NonNull StringProperty titleProperty() {
        return this.title;
    }

    @Override
    public @NonNull ObjectProperty<Application> applicationProperty() {
        return this.application;
    }

    public @NonNull ObservableMap<Key<?>, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void destroy() {
        this.getNode().disableProperty().unbind();
        ArrayList nodes = new ArrayList();
        new PreorderSpliterator(n -> n instanceof Parent ? ((Parent)n).getChildrenUnmodifiable() : Collections.emptyList(), (Object)this.getNode()).forEachRemaining(nodes::add);
        for (Node node : nodes) {
            if (node instanceof TableView) {
                ((TableView)node).setItems(FXCollections.emptyObservableList());
                ((TableView)node).setSelectionModel(null);
                continue;
            }
            if (!(node instanceof ListView)) continue;
            ((ListView)node).setItems(FXCollections.emptyObservableList());
        }
        for (Node node : nodes) {
            if (node instanceof TableRow) {
                ((TableRow)node).setItem(null);
                continue;
            }
            if (node instanceof ListCell) {
                ((ListCell)node).setItem(null);
                continue;
            }
            if (!(node instanceof Pane)) continue;
            ((Pane)node).getChildren().clear();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
    }

    @Override
    public void init() {
        this.initView();
        this.initTitle();
        this.initActions((ObservableMap<String, Action>)this.getActions());
        this.getNode().disableProperty().bind((ObservableValue)this.disabledProperty());
    }

    protected abstract void initTitle();

    @Override
    public @NonNull ReadOnlyMapProperty<String, Action> actionsProperty() {
        return this.actions;
    }
}

