/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.net.URI;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.AbstractActivity;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.action.file.CloseFileAction;
import org.jhotdraw8.application.action.file.ExportFileAction;
import org.jhotdraw8.application.action.file.RevertFileAction;
import org.jhotdraw8.application.action.file.SaveFileAction;
import org.jhotdraw8.application.action.file.SaveFileAsAction;
import org.jhotdraw8.base.net.UriUtil;
import org.jhotdraw8.fxbase.binding.CustomBinding;

public abstract class AbstractFileBasedActivity
extends AbstractActivity
implements FileBasedActivity {
    protected final BooleanProperty modified = new SimpleBooleanProperty(this, this, "modified"){

        public void set(boolean newValue) {
            super.set(newValue);
        }
    };
    protected final ObjectProperty<URI> uri = new SimpleObjectProperty((Object)this, "uri");
    protected final ObjectProperty<DataFormat> dataFormat = new SimpleObjectProperty((Object)this, "dataFormat");

    @Override
    protected void initTitle() {
        this.titleProperty().bind((ObservableValue)CustomBinding.convert(this.uri, uri -> uri == null ? this.getApplication().getResources().getString("unnamedFile") : UriUtil.getName((URI)uri)));
    }

    public @NonNull BooleanProperty modifiedProperty() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified.set(false);
    }

    protected void markAsModified() {
        this.modified.set(true);
    }

    @Override
    public @NonNull ObjectProperty<URI> uriProperty() {
        return this.uri;
    }

    @Override
    public @NonNull ObjectProperty<DataFormat> dataFormatProperty() {
        return this.dataFormat;
    }

    @Override
    protected void initActions(@NonNull ObservableMap<String, Action> map) {
        map.put((Object)"file.revert", (Object)new RevertFileAction(this));
        map.put((Object)"file.save", (Object)new SaveFileAction(this));
        map.put((Object)"file.saveAs", (Object)new SaveFileAsAction(this));
        map.put((Object)"file.export", (Object)new ExportFileAction(this));
        map.put((Object)"file.close", (Object)new CloseFileAction(this));
    }

    @Override
    public void destroy() {
        this.clear();
        super.destroy();
    }
}

