/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.AbstractApplication;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.FileBasedActivity;
import org.jhotdraw8.application.FileBasedApplication;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.action.Actions;
import org.jhotdraw8.application.action.ScreenMenuBarProxyAction;
import org.jhotdraw8.application.action.app.AboutAction;
import org.jhotdraw8.application.action.app.ExitAction;
import org.jhotdraw8.application.action.edit.ClearSelectionAction;
import org.jhotdraw8.application.action.edit.CopyAction;
import org.jhotdraw8.application.action.edit.CutAction;
import org.jhotdraw8.application.action.edit.DeleteAction;
import org.jhotdraw8.application.action.edit.PasteAction;
import org.jhotdraw8.application.action.edit.SelectAllAction;
import org.jhotdraw8.application.action.file.ClearRecentFilesMenuAction;
import org.jhotdraw8.application.action.file.CloseFileAction;
import org.jhotdraw8.application.action.file.NewFileAction;
import org.jhotdraw8.application.action.file.OpenFileAction;
import org.jhotdraw8.application.action.file.OpenRecentFileAction;
import org.jhotdraw8.application.prefs.PreferencesUtil;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.text.NaturalSortCollator;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.concurrent.FXWorker;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxbase.tree.PreorderSpliterator;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;
import org.jhotdraw8.fxcollection.typesafekey.SimpleParameterizedType;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public abstract class AbstractFileBasedApplication
extends AbstractApplication
implements FileBasedApplication {
    private static final @NonNull Key<ChangeListener<Boolean>> FOCUS_LISTENER_KEY = new NullableObjectKey("focusListener", (Type)new SimpleParameterizedType(ChangeListener.class, new Type[]{Boolean.class}));
    private static final @NonNull Key<Stage> STAGE_KEY = new NullableObjectKey("stage", Stage.class);
    public static final @NonNull String WINDOW_MENU_ID = "window";
    public static final String FILE_OPEN_RECENT_MENU = "file.openRecentMenu";
    private final Logger LOGGER = Logger.getLogger(AbstractFileBasedApplication.class.getName());
    private final ReadOnlyObjectWrapper<Activity> activeActivity = new ReadOnlyObjectWrapper();
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), r -> {
        Thread t = new Thread(r);
        t.setUncaughtExceptionHandler((t1, e) -> {
            throw (RuntimeException)e;
        });
        return t;
    });
    private boolean isSystemMenuSupported;
    private final @NonNull ArrayList<Action> systemMenuActiveViewActions = new ArrayList();
    private List<Menu> systemMenus;

    public static void main(String[] args) {
        AbstractFileBasedApplication.launch((String[])args);
    }

    public AbstractFileBasedApplication() {
        this.activeActivity.addListener((o, oldv, newv) -> {
            if (oldv != null) {
                this.onActivityDeactivated((FileBasedActivity)oldv);
            }
            if (newv != null) {
                this.onActivityActivated((FileBasedActivity)newv);
            }
        });
        this.getActivities().addListener(c -> {
            if (c.wasRemoved()) {
                this.onActivityRemoved((FileBasedActivity)c.getElementRemoved());
            }
            if (c.wasAdded()) {
                this.onActivityAdded((FileBasedActivity)c.getElementAdded());
            }
        });
        this.getRecentUris().addListener(this::updateRecentMenuItemsInAllMenuBars);
    }

    @Override
    public ReadOnlyObjectProperty<Activity> activeActivityProperty() {
        return this.activeActivity.getReadOnlyProperty();
    }

    protected @Nullable MenuBar createMenuBar(@Nullable FileBasedActivity activity, @Nullable Stage stage, @NonNull Map<String, Action> actions) {
        MenuBar mb;
        Supplier factory = this.getMenuBarFactory();
        MenuBar menuBar = mb = factory == null ? null : (MenuBar)factory.get();
        if (mb == null) {
            return null;
        }
        LinkedList<Menu> todo = new LinkedList<Menu>((Collection<Menu>)mb.getMenus());
        ArrayList<KeyCombination> accelerators = new ArrayList<KeyCombination>();
        while (!todo.isEmpty()) {
            Menu menu = (Menu)todo.remove();
            if (WINDOW_MENU_ID.equals(menu.getId())) {
                this.createWindowMenu(activity, menu);
                continue;
            }
            for (MenuItem mi : menu.getItems()) {
                KeyCombination accelerator;
                if (mi instanceof Menu) {
                    todo.add((Menu)mi);
                    continue;
                }
                String id = mi.getId();
                Action a = actions.get(id);
                if (a != null) {
                    Actions.bindMenuItem(mi, a);
                } else {
                    a = new ScreenMenuBarProxyAction(this, id);
                    a.set((MapAccessor)Action.LABEL, mi.getText());
                    this.systemMenuActiveViewActions.add(a);
                    Actions.bindMenuItem(mi, a, true);
                }
                if ((accelerator = mi.getAccelerator()) == null) continue;
                accelerators.add(accelerator);
            }
        }
        this.updateRecentMenuItemsInMenuBar((List<Menu>)mb.getMenus());
        if (stage != null) {
            stage.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
                for (KeyCombination acc : accelerators) {
                    if (!acc.match(event)) continue;
                    event.consume();
                }
            });
        }
        return mb;
    }

    private void createWindowMenu(@Nullable FileBasedActivity activity, Menu menu) {
        WeakHashMap menuItemMap = new WeakHashMap();
        CustomBinding.bindListContentToSet((ObservableList)menu.getItems(), (ObservableSet)this.getActivities(), v -> (MenuItem)menuItemMap.computeIfAbsent(v, k -> {
            CheckMenuItem menuItem = new CheckMenuItem();
            menuItem.textProperty().bind((ObservableValue)CustomBinding.formatted((String)this.getResources().getString("frame.title"), (Object[])new Object[]{v.titleProperty(), this.get((MapAccessor)NAME_KEY), v.disambiguationProperty(), ((FileBasedActivity)v).modifiedProperty()}));
            menuItem.setOnAction(evt -> {
                Stage s = (Stage)v.get((MapAccessor)STAGE_KEY);
                if (s != null) {
                    s.requestFocus();
                }
            });
            ChangeListener activityChangeListener = (observable, oldValue, newValue) -> menuItem.setSelected(newValue == v);
            menuItem.getProperties().put((Object)"activityChangeListener", (Object)activityChangeListener);
            this.activeActivityProperty().addListener((ChangeListener)new WeakChangeListener(activityChangeListener));
            return menuItem;
        }), menuItem -> {
            menuItem.setOnAction(null);
            menuItem.textProperty().unbind();
            ChangeListener activityChangeListener = (ChangeListener)menuItem.getProperties().remove((Object)"activityChangeListener");
            if (activityChangeListener != null) {
                this.activeActivityProperty().removeListener(activityChangeListener);
            }
        });
    }

    private void disambiguateActivities() {
        HashMap<String, ArrayList> titles = new HashMap<String, ArrayList>();
        for (Activity v : this.getActivities()) {
            String t = v.getTitle();
            titles.computeIfAbsent(t, k -> new ArrayList()).add(v);
        }
        for (ArrayList list : titles.values()) {
            if (list.size() == 1) {
                ((Activity)list.getFirst()).setDisambiguation(0);
                continue;
            }
            int max = 0;
            for (Activity v : list) {
                max = Math.max(max, v.getDisambiguation());
            }
            list.sort(Comparator.comparingInt(Activity::getDisambiguation));
            int prev = 0;
            for (Activity v : list) {
                int current = v.getDisambiguation();
                if (current == prev) {
                    v.setDisambiguation(++max);
                }
                prev = current;
            }
        }
    }

    @Override
    public void exit() {
        System.exit(0);
    }

    protected void onActivityActivated(@NonNull FileBasedActivity view) {
    }

    protected void onActivityAdded(@NonNull FileBasedActivity activity) {
        activity.setApplication(this);
        activity.init();
        ObservableMap<String, Action> map = activity.getActions();
        map.put((Object)"file.close", (Object)new CloseFileAction(activity));
        Stage stage = this.createStage(activity);
        activity.titleProperty().addListener(this::onTitleChanged);
        activity.set((MapAccessor)STAGE_KEY, stage);
        WeakReference<AbstractFileBasedApplication> appRef = new WeakReference<AbstractFileBasedApplication>(this);
        WeakReference<FileBasedActivity> activityRef = new WeakReference<FileBasedActivity>(activity);
        ChangeListener focusListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                AbstractFileBasedApplication app = (AbstractFileBasedApplication)appRef.get();
                FileBasedActivity act = (FileBasedActivity)activityRef.get();
                if (app != null && act != null) {
                    app.activeActivity.set((Object)act);
                }
            }
        };
        activity.set((MapAccessor)FOCUS_LISTENER_KEY, focusListener);
        stage.focusedProperty().addListener(focusListener);
        stage.setOnCloseRequest(event -> {
            event.consume();
            FileBasedActivity act = (FileBasedActivity)activityRef.get();
            if (act != null) {
                ((Action)act.getActions().get((Object)"file.close")).handle((Event)new ActionEvent(event.getSource(), event.getTarget()));
            }
        });
        this.disambiguateActivities();
        Screen screen = Screen.getPrimary();
        if (screen != null) {
            Rectangle2D bounds = screen.getVisualBounds();
            Random r = new Random();
            if (this.activeActivity.get() != null) {
                Window w = ((Activity)this.activeActivity.get()).getNode().getScene().getWindow();
                stage.setX(Math.min(w.getX() + 22.0, bounds.getMaxX() - stage.getWidth()));
                stage.setY(Math.min(w.getY() + 22.0, bounds.getMaxY() - stage.getHeight()));
            } else {
                stage.setX(bounds.getMinX());
                stage.setY(bounds.getMinY());
            }
            block0: for (int retries = this.getActivities().size(); retries > 0; --retries) {
                for (Activity v : this.getActivities()) {
                    Window w;
                    if (v == activity || !(Math.abs((w = v.getNode().getScene().getWindow()).getX() - stage.getX()) < 10.0) && !(Math.abs(w.getY() - stage.getY()) < 10.0)) continue;
                    stage.setX(Math.min(w.getX() + 20.0, bounds.getMaxX() - stage.getWidth()));
                    stage.setY(Math.min(w.getY() + 20.0, bounds.getMaxY() - stage.getHeight()));
                    continue block0;
                }
            }
        }
        stage.show();
        Platform.runLater(activity::start);
    }

    protected @NonNull Stage createStage(@NonNull FileBasedActivity activity) {
        LinkedHashMap<String, Action> allActions;
        MenuBar mb;
        Stage stage = new Stage();
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter(activity.getNode());
        if (!this.isSystemMenuSupported && (mb = this.createMenuBar(activity, stage, allActions = new LinkedHashMap<String, Action>((Map<String, Action>)this.getActions()))) != null) {
            mb.setUseSystemMenuBar(true);
            borderPane.setTop((Node)mb);
        }
        Scene scene = new Scene((Parent)borderPane);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().addAll((Collection)this.getStylesheets());
        Node frameIcon = this.getResources().getSmallIconProperty("frame", this.getClass());
        if (frameIcon instanceof ImageView) {
            stage.getIcons().setAll((Object[])new Image[]{((ImageView)frameIcon).getImage()});
        }
        stage.setScene(scene);
        PreferencesUtil.installStagePrefsHandler(this.getPreferences(), "stage", stage);
        stage.titleProperty().bind((ObservableValue)CustomBinding.formatted((String)this.getResources().getString("frame.title"), (Object[])new Object[]{activity.titleProperty(), this.get((MapAccessor)NAME_KEY), activity.disambiguationProperty(), activity.modifiedProperty()}));
        return stage;
    }

    protected void onActivityDeactivated(@NonNull FileBasedActivity view) {
    }

    protected void onActivityRemoved(@NonNull FileBasedActivity activity) {
        Stage stage = (Stage)activity.getNode().getScene().getWindow();
        activity.stop();
        ChangeListener focusListener = (ChangeListener)activity.get((MapAccessor)FOCUS_LISTENER_KEY);
        if (focusListener != null) {
            stage.focusedProperty().removeListener(focusListener);
        }
        activity.destroy();
        activity.titleProperty().removeListener(this::onTitleChanged);
        this.destroyStage(stage);
        if (this.activeActivity.get() == activity) {
            this.activeActivity.set(null);
        }
        FXWorker.run(() -> Thread.sleep(33L)).thenRun(() -> ((Stage)stage).close());
        System.gc();
        if (this.getActivities().isEmpty() && !this.isSystemMenuSupported) {
            this.exit();
        }
    }

    private void destroyStage(Stage stage) {
        Scene scene = stage.getScene();
        BorderPane borderPane = (BorderPane)scene.getRoot();
        MenuBar menuBar = (MenuBar)borderPane.getTop();
        if (menuBar != null) {
            this.destroyMenuBar(menuBar);
        }
        stage.setOnCloseRequest(null);
        stage.titleProperty().unbind();
        borderPane.setCenter(null);
        scene.setRoot((Parent)new BorderPane());
    }

    private void destroyMenuBar(MenuBar menuBar) {
        menuBar.setUseSystemMenuBar(false);
        ArrayList items = new ArrayList();
        new PreorderSpliterator(o -> {
            if (o instanceof MenuBar) {
                return ((MenuBar)o).getMenus();
            }
            if (o instanceof Menu) {
                return ((Menu)o).getItems();
            }
            return Collections.emptyList();
        }, (Object)menuBar).forEachRemaining(node -> {
            if (node instanceof Menu) {
                CustomBinding.unbindListContentToSet((ObservableList)((Menu)node).getItems(), (ObservableSet)this.getActivities());
            } else if (node instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)node;
                menuItem.setOnAction(null);
                menuItem.textProperty().unbind();
                ChangeListener activityChangeListener = (ChangeListener)menuItem.getProperties().remove((Object)"activityChangeListener");
                if (activityChangeListener != null) {
                    menuItem.getProperties().remove((Object)activityChangeListener);
                }
                items.add(menuItem);
            }
        });
        items.forEach(item -> {
            Menu parentMenu = item.getParentMenu();
            if (parentMenu != null) {
                parentMenu.getItems().remove(item);
            }
        });
    }

    protected void onTitleChanged(Observable obs) {
        this.disambiguateActivities();
    }

    public void start(Stage primaryStage) {
        List<URI> urisToOpen;
        try {
            this.isSystemMenuSupported = false;
        }
        catch (IllegalAccessError e) {
            System.err.println("Warning: can not access com.sun.javafx.tk.Toolkit");
        }
        this.loadRecentUris((String)this.get((MapAccessor)NAME_KEY));
        if (this.isSystemMenuSupported) {
            // empty if block
        }
        if ((urisToOpen = this.getUrisToOpen()).isEmpty()) {
            this.openEmptyActivity();
        } else {
            for (URI uri : urisToOpen) {
                this.openActivityFrom(uri);
            }
        }
    }

    private void openActivityFrom(@NonNull URI uri) {
        Resources labels = ApplicationLabels.getResources();
        this.createActivity().whenComplete((pv, ex1) -> {
            FileBasedActivity v = (FileBasedActivity)pv;
            if (ex1 != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex1.getMessage(), (Throwable)ex1);
                Alert alert = new Alert(Alert.AlertType.ERROR, labels.getString("application.createView.error"), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.show();
                return;
            }
            this.getActivities().add((Object)v);
            v.addDisabler(this);
            v.read(uri, null, (ImmutableMap<Key<?>, Object>)ChampMap.of(), false, (WorkState<Void>)new SimpleWorkState()).whenComplete((result, ex) -> {
                if (ex != null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), (Throwable)ex);
                    Alert alert = new Alert(Alert.AlertType.ERROR, labels.getFormatted("file.open.couldntOpen.message", uri) + "\n" + ex.getMessage(), new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.show();
                } else {
                    v.setURI(uri);
                    v.setDataFormat((DataFormat)result);
                    v.clearModified();
                }
                v.removeDisabler(this);
            });
        }).handle((v, ex) -> {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), (Throwable)ex);
            Alert alert = new Alert(Alert.AlertType.ERROR, labels.getString("application.createView.error"), new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            this.exit();
            return null;
        });
    }

    private void openEmptyActivity() {
        Resources labels = ApplicationLabels.getResources();
        this.createActivity().whenComplete((pv, ex1) -> {
            FileBasedActivity v = (FileBasedActivity)pv;
            if (ex1 != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex1.getMessage(), (Throwable)ex1);
                Alert alert = new Alert(Alert.AlertType.ERROR, labels.getString("application.createView.error"), new ButtonType[0]);
                alert.getDialogPane().setMaxWidth(640.0);
                alert.show();
                return;
            }
            this.getActivities().add((Object)v);
            v.addDisabler(this);
            v.clear().whenComplete((result, ex) -> {
                if (ex != null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), (Throwable)ex);
                    Alert alert = new Alert(Alert.AlertType.ERROR, labels.getString("application.createView.error"), new ButtonType[0]);
                    alert.getDialogPane().setMaxWidth(640.0);
                    alert.show();
                } else {
                    v.clearModified();
                    v.removeDisabler(this);
                }
            });
        }).handle((v, ex) -> {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), (Throwable)ex);
            Alert alert = new Alert(Alert.AlertType.ERROR, labels.getString("application.createView.error"), new ButtonType[0]);
            alert.getDialogPane().setMaxWidth(640.0);
            alert.showAndWait();
            this.exit();
            return null;
        });
    }

    protected List<URI> getUrisToOpen() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String s : this.getParameters().getUnnamed()) {
            try {
                URI uri = new URI(s);
                if (uri.getScheme() == null) {
                    uri = Paths.get(s, new String[0]).toUri();
                }
                uris.add(uri);
            }
            catch (URISyntaxException e) {
                this.LOGGER.warning("Ignoring unnamed parameter, because it is not a legal URI: " + s);
            }
        }
        return uris;
    }

    private void updateRecentMenuItemsInAllMenuBars(Observable o) {
        if (this.isSystemMenuSupported) {
            if (this.systemMenus != null) {
                this.updateRecentMenuItemsInMenuBar(this.systemMenus);
            }
        } else {
            for (Activity v : this.getActivities()) {
                BorderPane bp = (BorderPane)v.getNode().getScene().getRoot();
                MenuBar mb = (MenuBar)bp.getTop();
                if (mb == null) continue;
                this.updateRecentMenuItemsInMenuBar((List<Menu>)mb.getMenus());
            }
        }
    }

    private void updateRecentMenuItemsInMenuBar(List<Menu> mb) {
        ArrayDeque<List<Object>> todo = new ArrayDeque<List<Object>>();
        todo.add(mb);
        while (!todo.isEmpty()) {
            for (Object mi : (List)todo.remove()) {
                if (!(mi instanceof Menu)) continue;
                Menu mmi = (Menu)mi;
                if (FILE_OPEN_RECENT_MENU.equals(mmi.getId())) {
                    mmi.getItems().clear();
                    List list = new ArrayList(this.getRecentUris().entrySet()).subList(0, Math.min(this.getRecentUris().size(), this.getMaxNumberOfRecentUris()));
                    list.sort(NaturalSortCollator.comparing(e -> ((URI)e.getKey()).toString()));
                    for (Map.Entry entry : list) {
                        URI uri = (URI)entry.getKey();
                        DataFormat format = (DataFormat)entry.getValue();
                        MenuItem mii = new MenuItem();
                        mii.setMnemonicParsing(false);
                        OpenRecentFileAction a = new OpenRecentFileAction(this, uri, format);
                        Actions.bindMenuItem(mii, a);
                        ((Menu)mi).getItems().add((Object)mii);
                    }
                    MenuItem mii = new MenuItem();
                    ClearRecentFilesMenuAction a = new ClearRecentFilesMenuAction(this);
                    Actions.bindMenuItem(mii, a);
                    mmi.getItems().add((Object)new SeparatorMenuItem());
                    mmi.getItems().add((Object)mii);
                    continue;
                }
                todo.add((List<Object>)mmi.getItems());
            }
        }
    }

    public final void init() {
        this.initResourceBundle();
        this.initProperties();
        this.initFactories();
        this.initActions((ObservableMap<String, Action>)this.getActions());
        this.initTheme();
    }

    protected void initTheme() {
    }

    protected void initResourceBundle() {
    }

    protected void initProperties() {
        this.set((MapAccessor)NAME_KEY, this.getClass().getSimpleName());
        this.set((MapAccessor)VERSION_KEY, this.getClass().getPackage().getImplementationVersion());
        this.set((MapAccessor)COPYRIGHT_KEY, this.getClass().getPackage().getImplementationVendor());
    }

    protected void initFactories() {
    }

    protected void initActions(@NonNull ObservableMap<String, Action> map) {
        map.put((Object)"application.about", (Object)new AboutAction(this));
        map.put((Object)"application.exit", (Object)new ExitAction(this));
        map.put((Object)"file.new", (Object)new NewFileAction(this));
        map.put((Object)"file.open", (Object)new OpenFileAction(this));
        map.put((Object)"edit.cut", (Object)new CutAction(this));
        map.put((Object)"edit.copy", (Object)new CopyAction(this));
        map.put((Object)"edit.paste", (Object)new PasteAction(this));
        map.put((Object)"edit.delete", (Object)new DeleteAction(this));
        map.put((Object)"edit.selectAll", (Object)new SelectAllAction(this));
        map.put((Object)"edit.clearSelection", (Object)new ClearSelectionAction(this));
    }
}

