/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.net.URI;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.application.action.Action;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.beans.PropertyBean;
import org.jhotdraw8.fxbase.concurrent.FXWorker;
import org.jhotdraw8.fxbase.control.Disableable;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.NullableObjectKey;

public interface Application
extends Disableable,
PropertyBean {
    public static final String ACTIONS_PROPERTY = "actions";
    public static final String ACTIVITIES_PROPERTY = "activities";
    public static final String ACTIVITY_FACTORY_PROPERTY = "activityFactory";
    public static final String RESOURCE_BUNDLE_PROPERTY = "resourceBundle";
    public static final String MENU_BAR_FACTORY_PROPERTY = "menuBarFactory";
    public static final String RECENT_URIS_PROPERTY = "recentUris";
    public static final String PREFERENCES_PROPERTY = "preferences";
    public static final String MAX_NUMBER_OF_RECENT_URIS_PROPERTY = "maxNumberOfRecentUris";
    public static final String STYLESHEETS_PROPERTY = "stylesheets";
    public static final Key<String> NAME_KEY = new NullableObjectKey("name", String.class);
    public static final Key<String> VERSION_KEY = new NullableObjectKey("version", String.class);
    public static final Key<String> COPYRIGHT_KEY = new NullableObjectKey("copyright", String.class);
    public static final Key<String> LICENSE_KEY = new NullableObjectKey("license", String.class);

    public @NonNull ReadOnlySetProperty<Activity> activitiesProperty();

    public Executor getExecutor();

    public @NonNull NonNullObjectProperty<Preferences> preferencesProperty();

    public @NonNull ReadOnlyMapProperty<String, Action> actionsProperty();

    default public @NonNull ObservableMap<String, Action> getActions() {
        return (ObservableMap)this.actionsProperty().get();
    }

    default public @NonNull Preferences getPreferences() {
        return (Preferences)this.preferencesProperty().get();
    }

    default public void setPreferences(@NonNull Preferences preferences) {
        this.preferencesProperty().set((Object)preferences);
    }

    public ReadOnlyMapProperty<URI, DataFormat> recentUrisProperty();

    default public @NonNull ObservableMap<URI, DataFormat> getRecentUris() {
        return (ObservableMap)this.recentUrisProperty().get();
    }

    public @NonNull IntegerProperty maxNumberOfRecentUrisProperty();

    default public @NonNull ObservableSet<Activity> getActivities() {
        return (ObservableSet)this.activitiesProperty().get();
    }

    public ReadOnlyObjectProperty<Activity> activeActivityProperty();

    default public @Nullable Activity getActiveActivity() {
        return (Activity)this.activeActivityProperty().get();
    }

    public void exit();

    default public @Nullable Node getNode() {
        return null;
    }

    default public CompletionStage<Activity> createActivity() {
        return FXWorker.supply(() -> {
            Supplier<Activity> factory = this.getActivityFactory();
            if (factory == null) {
                throw new IllegalStateException("Could not create a new Activity, because no activityFactory has been set.");
            }
            return factory.get();
        });
    }

    default public int getMaxNumberOfRecentUris() {
        return this.maxNumberOfRecentUrisProperty().get();
    }

    default public void setMaxNumberOfRecentUris(int newValue) {
        this.maxNumberOfRecentUrisProperty().set(newValue);
    }

    public @NonNull ObjectProperty<Supplier<Activity>> activityFactoryProperty();

    default public Supplier<Activity> getActivityFactory() {
        return (Supplier)this.activityFactoryProperty().get();
    }

    default public void setActivityFactory(Supplier<Activity> newValue) {
        this.activityFactoryProperty().set(newValue);
    }

    public @NonNull ObjectProperty<Supplier<MenuBar>> menuBarFactoryProperty();

    public @NonNull NonNullObjectProperty<Resources> resourcesProperty();

    default public @Nullable Supplier<MenuBar> getMenuBarFactory() {
        return (Supplier)this.menuBarFactoryProperty().get();
    }

    public @NonNull ReadOnlyListProperty<String> stylesheetsProperty();

    default public @NonNull ObservableList<String> getStylesheets() {
        return (ObservableList)this.stylesheetsProperty().get();
    }

    default public void setMenuBarFactory(@Nullable Supplier<MenuBar> newValue) {
        this.menuBarFactoryProperty().set(newValue);
    }

    default public @NonNull Resources getResources() {
        return (Resources)this.resourcesProperty().get();
    }

    default public void setResources(@NonNull Resources newValue) {
        this.resourcesProperty().set((Object)newValue);
    }
}

