/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application;

import java.net.URI;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.print.PrinterJob;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.application.Activity;
import org.jhotdraw8.fxbase.concurrent.CompletableWorker;
import org.jhotdraw8.fxbase.concurrent.FXWorker;
import org.jhotdraw8.fxbase.concurrent.SimpleCompletableWorker;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.icollection.immutable.ImmutableMap;

public interface FileBasedActivity
extends Activity {
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String URI_PROPERTY = "uri";
    public static final String DATA_FORMAT_PROPERTY = "dataFormat";

    public @NonNull ReadOnlyBooleanProperty modifiedProperty();

    default public boolean isModified() {
        return this.modifiedProperty().get();
    }

    public void clearModified();

    public @NonNull ObjectProperty<@Nullable URI> uriProperty();

    default public @Nullable URI getURI() {
        return (URI)this.uriProperty().get();
    }

    default public void setURI(@Nullable URI newValue) {
        this.uriProperty().set((Object)newValue);
    }

    public @NonNull ObjectProperty<@Nullable DataFormat> dataFormatProperty();

    default public @Nullable DataFormat getDataFormat() {
        return (DataFormat)this.dataFormatProperty().get();
    }

    default public void setDataFormat(@Nullable DataFormat newValue) {
        this.dataFormatProperty().set((Object)newValue);
    }

    public @NonNull CompletionStage<@NonNull DataFormat> read(@NonNull URI var1, @Nullable DataFormat var2, @NonNull ImmutableMap<Key<?>, Object> var3, boolean var4, WorkState<Void> var5);

    default public @NonNull CompletableWorker<Void> read(@NonNull URI uri, @NonNull ImmutableMap<Key<?>, Object> options) {
        SimpleCompletableWorker worker = new SimpleCompletableWorker((WorkState)new SimpleWorkState(this.getApplication().getResources().getFormatted("file.reading.worker.title", uri.getPath())));
        worker.completeExceptionally((Throwable)new UnsupportedOperationException());
        return worker;
    }

    public @NonNull CompletionStage<Void> write(@NonNull URI var1, @Nullable DataFormat var2, @NonNull ImmutableMap<Key<?>, Object> var3, @NonNull WorkState<Void> var4);

    default public @NonNull CompletableWorker<Void> write(@NonNull URI uri, @NonNull ImmutableMap<Key<?>, Object> options, WorkState<Void> state) {
        return FXWorker.work((Executor)this.getApplication().getExecutor(), s -> null, state);
    }

    public @NonNull CompletionStage<Void> clear();

    public @NonNull CompletionStage<Void> print(@NonNull PrinterJob var1, @NonNull WorkState<Void> var2);

    default public boolean isEmpty() {
        return !this.isModified() && this.getURI() == null;
    }

    @Override
    public @NonNull StringProperty titleProperty();
}

