/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.application.action;

import javafx.beans.binding.Binding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.application.action.Action;

public class Actions {
    public static void bindButton(@NonNull Button control, @NonNull Action action) {
        Binding nameBinding = Action.LABEL.valueAt(action.getProperties());
        control.getProperties().put((Object)"ActionsNameBinding", (Object)nameBinding);
        control.textProperty().bind((ObservableValue)Action.LABEL.valueAt(action.getProperties()));
        control.setOnAction((EventHandler)action);
        control.disableProperty().bind((ObservableValue)action.disabledProperty());
    }

    public static void bindMenuItem(@NonNull MenuItem control, @NonNull Action action) {
        Actions.bindMenuItem(control, action, true);
    }

    public static void bindMenuItem(@NonNull MenuItem control, @NonNull Action action, boolean bindLabel) {
        if (bindLabel) {
            Binding nameBinding = Action.LABEL.valueAt(action.getProperties());
            control.textProperty().bind((ObservableValue)nameBinding);
            Binding acceleratorBinding = Action.ACCELERATOR_KEY.valueAt(action.getProperties());
            control.acceleratorProperty().bind((ObservableValue)acceleratorBinding);
            control.getProperties().put((Object)"nameBinding", (Object)nameBinding);
            control.getProperties().put((Object)"acceleratorBinding", (Object)acceleratorBinding);
        }
        control.setOnAction((EventHandler)action);
        control.disableProperty().bind((ObservableValue)action.disabledProperty());
        if (control instanceof CheckMenuItem) {
            CheckMenuItem cmi = (CheckMenuItem)control;
            BooleanProperty selectedBinding = action.selectedProperty();
            selectedBinding.addListener((o, oldv, newv) -> cmi.setSelected(newv.booleanValue()));
            cmi.setSelected(action.isSelected());
        } else if (control instanceof RadioMenuItem) {
            RadioMenuItem cmi = (RadioMenuItem)control;
            BooleanProperty selectedBinding = action.selectedProperty();
            selectedBinding.addListener((o, oldv, newv) -> cmi.setSelected(newv.booleanValue()));
            cmi.setSelected(action.isSelected());
        }
    }

    private Actions() {
    }
}

